//===================================================================
//
// taskq.c (@sheart, @haekim)
//
// Des : executes registered works by the system thread at the nearest time
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#include "taskq.h"

#ifdef KERNEL_M
#include "critical_section.h"
#include "thread.h"
#include "sched.h"

TASKQ taskq;

// Work Queue : a set of functions to be run by the system thread as soon as possible
void nos_taskq_init()
{
        taskq.head = taskq.tail = 0;
}


// You must not use thread function in this function.
BOOL nos_taskq_reg(void (*func)(void))
{
	NOS_ENTER_CRITICAL_SECTION();
	UINT8 foo = (taskq.tail+1)%TASKQ_LEN;

	// insert *func into work queue.
	if (taskq.head == foo)		// if queue is full
	{
		NOS_EXIT_CRITICAL_SECTION();
		return FALSE; // cannot register work because the work queue is full
	}
	else
	{
		taskq.task[taskq.tail].func = func;
		taskq.tail = foo;
		if ( tcb[0]->priority != PRIORITY_ULTRA )
		{
			nos_thread_priority_change(0, PRIORITY_ULTRA);	// the idle thread becomes "super-thread" with ultra-highest-priority
			// Set the next scheduling timer flag
			SET_KERNEL_TIMER_FLAG();
		}
		NOS_EXIT_CRITICAL_SECTION();
		return TRUE;
	}
}

void nos_taskq_exe()
{
	NOS_ENTER_CRITICAL_SECTION();
	UINT8 temp_pos;

	while ( taskq.head != taskq.tail )	// not empty
	{
		temp_pos = taskq.head;
		taskq.head = (taskq.head+1)%TASKQ_LEN;	// move to the next work
		NOS_EXIT_CRITICAL_SECTION();
		
		(taskq.task[temp_pos].func)();	// execute a work function
		NOS_ENTER_CRITICAL_SECTION();
        }

	NOS_EXIT_CRITICAL_SECTION();
}
#endif
