//===================================================================
//
// sem.h (@jun361, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef SEM_H
#define SEM_H
#include "kconf.h"
#ifdef KERNEL_M
#ifdef SEM_M

#include "common.h"

typedef struct _semaphore
{
	volatile UINT8 val; 	// value of semaphore
} *SEMAPHORE;

SEMAPHORE nos_semaphore_create(UINT8 value);
void nos_semaphore_destroy(SEMAPHORE sem);
void nos_signal(SEMAPHORE sem);
void nos_wait(SEMAPHORE sem);

#endif // SEM_M
#endif // KERNEL_M
#endif // ~SEM_H
