//===================================================================
//
// sched.h (@jun361, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef SCHED_H
#define SCHED_H
#include "kconf.h"
#ifdef KERNEL_M

#include "common.h"

// priority setting
// LOWEST <<----------------->> HIGHEST
//   0     1     2     3     4     5 
#define PRIORITY_LEVEL_COUNT	6  // 6 prorities available - assignment : SYSTEM(0, 5), USER(1-4)  
#define PRIORITY_ULTRA		5  // reserved for the system thread
#define PRIORITY_HIGHEST	4
#define PRIORITY_HIGH		3
#define PRIORITY_NORMAL		2
#define PRIORITY_LOW		1
#define PRIORITY_LOWEST		0  // reserved for the idle thread

extern BOOL _sched_enable_bit;
#define NOS_ENABLE_SCHED()	do {_sched_enable_bit = 1;} while (0)
#define NOS_DISABLE_SCHED()	do {_sched_enable_bit = 0;} while (0)

#ifdef atmega128
void nos_context_switch_core(void) __attribute__ ((naked)); 
#endif
#ifdef msp430x1611
__attribute__ ((naked)) void nos_context_switch_core(void);
#endif

void nos_ctx_sw(void);
void nos_sched_init(void);
void nos_sched_start(void);

#endif // KERNEL_M
#endif // ~SCHED_H
