//===================================================================
//
// nos_init.h (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef NOS_INIT_H
#define NOS_INIT_H
#include "kconf.h"
#include "common.h"

#include "platform.h"	// Platform type
#include "arch.h"	// MCU type
#include "intr.h"

#ifdef KERNEL_M
#include "kernel.h"
// NOS_HEAP_INIT();(nos_arch_init();) must be placed 1st line because other _init_* functions may allocate memory.
#define NOS_INIT() \
	do { \
		NOS_DISABLE_GLOBAL_INTERRUPT(); \
		nos_arch_init(); \
		nos_kernel_init(); \
		nos_platform_init(); \
		NOS_ENABLE_GLOBAL_INTERRUPT(); \
	} while(0)
#else
#define NOS_INIT() \
	do { \
		NOS_DISABLE_GLOBAL_INTERRUPT(); \
		nos_arch_init(); \
		nos_platform_init(); \
		NOS_ENABLE_GLOBAL_INTERRUPT(); \
	} while(0)
#endif

#endif //~NOS_INIT_H

