//===================================================================
//
// common.h (@sheart, @jun361, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef COMMON_H
#define COMMON_H

#include "typedef.h"

// ASCII Characters
#define _BS (0x08)    // Back Space (ASCII)
#define _CR (0x0D)    // Carrage Return (ASCII)

#define _BIT_SET(reg,n)	((reg) |= (1 << (n)))
#define _BIT_CLR(reg,n)	((reg) &= ~(1 << (n)))
#define _IS_SET(reg,n)	((reg) & (1 << (n)))
#define _MIN(n,m)	(((n) < (m)) ? (n) : (m))	// get a minimum number among n and m
#define _MAX(n,m)	(((n) < (m)) ? (m) : (n))	// get a max number among n and m
#define _ABS(n)		(((n) < 0) ? (-(n)) : (n))	// get absolute number 

//#ifndef FALSE
#define FALSE		(0)
//#endif
//#ifndef TRUE
#define TRUE		(1)
//#endif
//#ifndef FAIL
#define FAIL		(0)
//#endif
//#ifndef SUCCESS
#define SUCCESS		(1)
//#endif
#ifndef NULL
#define NULL		(0)
#endif


#endif // COMMON_H
