//===================================================================
//
// api_nano_24.h (@haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef API_NANO_24_H
#define API_NANO_24_H

#ifdef SENSOR_GAS_M
#include "sensor_gas.h"
#define gas_power_on()		NOS_GAS_POWER_ON()
#define gas_power_off()		NOS_GAS_POWER_OFF()
#define gas_get_data()		nos_gas_get_data()	//UINT16 nos_gas_get_data(void)
#endif

#ifdef SENSOR_HUM_M
#include "sensor_hum.h"
#define hum_power_on()		NOS_HUM_POWER_ON()
#define hum_power_off()		NOS_HUM_POWER_OFF()
#define hum_get_data()		nos_hum_get_data()	//UINT16 nos_hum_get_data(void)
#endif

#ifdef SENSOR_LIGHT_M
#include "sensor_light.h"
#define light_power_on()	NOS_LIGHT_POWER_ON()
#define light_power_off()	NOS_LIGHT_POWER_OFF()
#define light_get_data()	nos_light_get_data()	//UINT16 nos_light_get_data(void)
#endif 

#ifdef SENSOR_TEMP_M
#include "sensor_temp.h"
#define temp_power_on()		NOS_TEMP_POWER_ON()
#define temp_power_off()	NOS_TEMP_POWER_OFF()
#define temp_get_data()		nos_temp_get_data()	//INT16 nos_temp_get_data(void)
#endif

#ifdef SENSOR_PIR_M
#include "sensor_pir.h"
#define pir_power_on()		NOS_PIR_POWER_ON()
#define pir_power_off()		NOS_PIR_POWER_OFF()
#define pir_callback(func)	nos_pir_callback(func)	//void nos_pir_callback(void (*func)(void))
#endif

#ifdef SENSOR_US_M
#include "sensor_us.h"
#define us_power_on()		NOS_US_POWER_ON()
#define us_power_off()		NOS_US_POWER_OFF()
#define us_callback(func)	nos_us_callback(func)	//void nos_us_callback(void (*func)(void))
#define us_trigger()		nos_us_trigger()
#define us_get_data()		nos_us_get_data()	//UINT16 nos_us_get_data(void)
#endif

#endif	//~API_H
