//===================================================================
//
// api.h (@haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef API_H
#define API_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// common definitions
#include "nos_init.h"
#define nos_init()		NOS_INIT()

#include "heap.h"
#define malloc(length)		nos_malloc(length)	//void *nos_malloc(UINT16 len)
#define free(ptr)		nos_free(ptr)	//void nos_free(void *p)

#include "critical_section.h"
#define ENTER_CRITICAL()	NOS_ENTER_CRITICAL_SECTION()
#define EXIT_CRITICAL()		NOS_EXIT_CRITICAL_SECTION()

#include "arch.h"
#define delay_us(time)		nos_delay_us(time)	//void nod_delay_us(UINT16 timeout)
#define delay_ms(time)		nos_delay_ms(time)	//void nos_delay_ms(UINT16 timeout)

#ifdef TIMECHK_M
#include "time_check.h"
// MAXIMUM measurable time : 2sec. measured by 30us unit
#ifdef UART_M
#define timechk_start()			NOS_TIMECHK_START()
#define timechk_end()			NOS_TIMECHK_END()
#define timechk_print()			nos_timechk_print()
#define print_local_clock()		nos_local_clock_print()
#endif
#define get_local_sec()			NOS_GET_LOCAL_CLOCK_SEC()
#define get_local_min()			NOS_GET_LOCAL_CLOCK_MIN()
#define get_local_hour()		NOS_GET_LOCAL_CLOCK_HOUR()
#endif

#include "pwr_mgr.h"
#define mcu_sleep_set_mode(mode)	NOS_SET_SLEEP_MODE(mode)
#define mcu_sleep()			NOS_SLEEP_MCU()
#define enable_mcu_sleep()		NOS_SLEEP_ENABLE()
#define disable_mcu_sleep()		NOS_SLEEP_DISABLE()

#ifdef KERNEL_M
#include "kernel.h"
#define enable_sched()			NOS_ENABLE_SCHED()
#define disable_sched()			NOS_DISABLE_SCHED()
#define context_sw()			nos_ctx_sw()
#define sched_start()			nos_sched_start()
#define taskq_reg(func)			nos_taskq_reg(func)//BOOL nos_taskq_reg(void (*func)(void))

#define timer_create(func, ticks, opt)		nos_timer_create(func, ticks, opt)	//INT8 nos_timer_create(void (*func)(void), UINT16 ticks, UINT8 opt)
#define timer_create_ms(func, ms, opt)		nos_timer_create_ms(func, ms, opt)
#define timer_create_sec(func, sec, opt)		nos_timer_create_sec(func, sec, opt)
#define timer_destroy(tmid)		nos_timer_destroy(tmid)
#define timer_activate(tmid)		nos_timer_activate(tmid)		
#define timer_deactivate(tmid)		nos_timer_deactivate(tmid)		

#define get_thread_id()			NOS_GET_THREAD_ID()
#define get_thread_state(tid)		NOS_GET_THREAD_STATE(tid)
#define get_thread_prior(tid)		NOS_GET_THREAD_PRIORITY(tid)
#define get_thread_stack_ptr(tid)	NOS_GET_THREAD_STACK_POINTER(tid)
#define get_thread_stack_unused_space(tid)	NOS_GET_THREAD_STACK_UNUSED_SPACE(tid)	
#define get_num_user_threads()		nos_get_num_user_threads()	//UINT8 nos_get_num_user_threads(void)

#define thread_sleep(ticks)			nos_thread_sleep(ticks)		//void  nos_thread_sleep(UINT16 ms)
#define thread_sleep_ms(ms)			nos_thread_sleep_ms(ms)		//void  nos_thread_sleep_ms(UINT16 ms)
#define thread_sleep_sec(sec)			nos_thread_sleep_sec(sec)	//void  nos_thread_sleep_sec(UINT16 sec)
#define thread_wakeup(tid)		nos_thread_wakeup(tid)		//UINT8 nos_thread_wakeup(UINT8 tid)
#define thread_priority_change(tid, pri)	nos_thread_priority_change(tid, pri)	//UINT8 nos_thread_priority_change(UINT8 tid, UINT8 new_priority),  4:highest, 1:lowest

#ifdef THREAD_MANUAL_NUMBERING_M
#define thread_create(id, func, args, stack, pri)	nos_thread_create(id, func, args, stack, pri)	//UINT8 nos_thread_create(UINT8 id, void (*func)(void *args), void *args_data, UINT16 stack_size, UINT8 priority);
#else
#define thread_create(func, args, stack, pri)	nos_thread_create(func, args, stack, pri)	//INT8 nos_thread_create(void (*func)(void *args), void *args_data, UINT16 stack_size, UINT8 priority);
#endif
#define thread_join(tid)		nos_thread_join(tid)	//void nos_thread_join(UINT8 tid)
#define thread_exit()			nos_thread_exit()
#define thread_suspend(tid)		nos_thread_suspend(tid)	//void nos_thread_suspend(UINT8 tid)
#define thread_resume(tid)		nos_thread_resume(tid)	//UINT8 nos_thread_resume(UINT8 tid)

#ifdef SEM_M
#include "sem.h"
#define sem_create(val)			nos_semaphore_create(val)	//SEMAPHORE nos_semaphore_create(UINT8 value)
#define sem_destroy(sem)		nos_semaphore_destroy(sem)	//void nos_semaphore_destroy(SEMAPHORE sem)
#define sem_signal(sem)			nos_signal(sem)	//void nos_signal(SEMAPHORE sem)
#define sem_wait(sem)			nos_wait(sem)	//void nos_wait(SEMAPHORE sem)
#endif

#ifdef MSGQ_M
#include "msgq.h"
#define msgq_create(type, len)		nos_msgq_create(type, len)	//MSGQ  nos_msgq_create(UINT8 type, UINT8 len)
#define msgq_destroy(msgq)		nos_msgq_destroy(msgq)	//void  nos_msgq_destroy(MSGQ mq)
#define msgq_send(q, data)		nos_msgq_send(q, data)		//UINT8 nos_msgq_send(MSGQ mq, void *data)
#define msgq_recv(q, data)		nos_msgq_recv(q, data)		//UINT8 nos_msgq_recv(MSGQ mq, void *data);
#define msgq_isend(q, data)		nos_msgq_isend(q, data)		//UINT8 nos_msgq_send(MSGQ mq, void *data)
#define msgq_irecv(q, data)		nos_msgq_irecv(q, data)		//UINT8 nos_msgq_recv(MSGQ mq, void *data);
#define msgq_test_isend(q)		nos_msgq_test_isend(q)		//UINT8 nos_msgq_send(MSGQ mq, void *data)
#define msgq_test_irecv(q)		nos_msgq_test_irecv(q)		//UINT8 nos_msgq_recv(MSGQ mq, void *data);
#define msgq_wait_until_isend_complete(q)	nos_msgq_wait_until_isend_complete(q)		//UINT8 nos_msgq_send(MSGQ mq, void *data)
#define msgq_wait_until_irecv_complete(q)	nos_msgq_wait_until_irecv_complete(q)		//UINT8 nos_msgq_send(MSGQ mq, void *data)
#endif

#endif // ~KERNEL_M


// Functions and Devices
#ifdef LED_M
#include "led.h"
#define led_on(n)			NOS_LED_ON(n)
#define led_off(n)			NOS_LED_OFF(n)
#define led_toggle(n)			NOS_LED_TOGGLE(n)
#endif

#ifdef UART_M
#include "uart.h"
#define enable_uart_rx_intr()		NOS_ENABLE_UART_RX_INTR(STDIN)
#define disable_uart_rx_intr()		NOS_DISABLE_UART_RX_INTR(STDIN)
#define uart_getc_callback(func)	nos_uart_getc_callback(STDIN, func)	//void nos_uart_getc_callback(UINT8 port_num, void (*func)(UINT8))
#define uart_gets(str, length)		nos_uart_gets(STDIN, str, length)		//void nos_uart_gets(UINT8 port_num, INT8 *str, UINT8 str_size)
#define uart_putc(byte)			nos_uart_putc(STDOUT, byte)	//void nos_uart_putc(UINT8 port_num, UINT8 byte)
#define uart_puti(int)			nos_uart_puti(STDOUT, int)	//void nos_uart_puti(UINT8 port_num, INT16 val)
#define uart_putu(uint)			nos_uart_putu(STDOUT, uint)	//void nos_uart_putu(UINT8 port_num, UINT16 val)
#define uart_puts(str)			nos_uart_puts(STDOUT, str)	//void nos_uart_puts(UINT8 port_num, INT8 *str)
extern void uart_printf(const INT8 *msg, ...);
#endif


// Network

#ifdef MAC_M
#include "mac.h"
#define MAC_MAX_PAYLOAD_SIZE	NOS_MAC_MAX_PAYLOAD_SIZE
#define mac_rx_on()		nos_mac_rx_on()
#define mac_rx_off()	nos_mac_rx_off()
#define mac_init(channel, panaddr, myaddr)	nos_mac_init(channel, panaddr, myaddr)	//void nmac_init(UINT8 channel, UINT16 panid, UINT16 myaddr)
#define mac_set_tx_power(level)	nos_mac_set_tx_power(level)	// void nmac_set_tx_power(UINT8 level);
#define mac_set_rx_cb(func)		nos_mac_set_rx_cb(func)	//void nmac_set_rx_cb(void (*func)(void));
#define mac_tx_noack(frame)		nos_mac_tx_noack(frame)		//BOOL nmac_tx_noack (NMAC_TX_INFO* nmac_tx_info_ptr)
#define mac_tx(frame)			nos_mac_tx(frame)	//BOOL nmac_tx(NMAC_TX_INFO* nmac_tx_info_ptr)
#define mac_rx(frame)			nos_mac_rx(frame)	//BOOL nmac_rx(NMAC_RX_INFO* nmac_rx_info_ptr)
#ifdef DEMO_MAC_M
#define mac_set_rx_range(min, max)		nos_mac_set_rx_range(min, max)	//void nmac_set_rx_range(UINT16 min_addr, UINT16 max_addr)
#endif
#endif

#ifdef ROUTING_M
#include "routing.h"
#define NWK_MAX_PAYLOAD_SIZE	NOS_NWK_MAX_PAYLOAD_SIZE
#ifdef RENO_M
#define nwk_init(channel, panaddr, node_id, min, max)	nos_nwk_init(channel, panaddr, node_id, min, max) //(UINT8 channel, UINT16 pan_id, UINT8 node_id, UINT8 min_permit_id, UINT8 max_permit_id)
#define nwk_set_rx_cb(func)			nos_nwk_set_rx_cb(func)	//(void (*func)(void))
#define nwk_rx(src_id, len, data)	nos_nwk_rx(src_id, len, data) //BOOL (UINT8* src_id, UINT8* data_length, void* data)
#define nwk_tx(dest_id, len, data)	nos_nwk_tx(dest_id, len, data) //void (UINT8 dest_id, UINT8 data_length, void *data)
#endif
#ifdef TENO_M
#define nwk_init(channel, panaddr, node_id)	nos_nwk_init(channel, panaddr, node_id) // void teno_init(UINT8 channel, UINT16 pan_id, UINT16 node_id);
#define nwk_set_rx_cb(func)					nos_nwk_set_rx_cb(func) // void teno_set_rx_cb(void (*func)(void));
#define nwk_set_to_sink()					nos_nwk_set_to_sink() // void teno_role_as_sink(void);
#define nwk_set_to_node()					nos_nwk_set_to_node() //void teno_role_as_node(void);
#define nwk_rx(src_id, port, len, data)		nos_nwk_rx(src_id, port, len, data, NULL, NULL) //void teno_recv_from_nwk(UINT16* src_id, UINT8* port, UINT8* data_length, void* data, UINT16* parent_id, UINT16* dest_id);
#define nwk_tx_to_sink(port, len, data)		nos_nwk_tx_to_sink(port, len, data) //BOOL teno_send_to_sink(UINT8 port, UINT8 data_length, void* data);
#define nwk_tx(dest_id, port, len, data)	nos_nwk_tx(dest_id, port, len, data) //BOOL teno_send_to_node(UINT16 dest_id, UINT8 port, UINT8 data_length, void* data);
#ifdef DEMO_MAC_M
#define nwk_set_rx_range(min_permit_id, max_permit_id)	nos_nwk_set_rx_range(min_permit_id, max_permit_id) //void teno_set_rx_range(UINT16 min_permit_id, UINT16 max_permit_id);
#endif
#endif
#endif


// platform specific definitions
#ifdef ETRI_SSN
#include "api_etri_ssn.h"
#endif
#ifdef NANO_24
#include "api_nano_24.h"
#endif
#ifdef ZIGBEX
#include "api_zigbex.h"
#endif
#ifdef MICAZ
#include "api_micaz.h"
#endif
#ifdef ISN_400N
#include "api_isn_400n.h"
#endif
#ifdef UBI_MSP
#include "api_ubi_msp.h"
#endif
#ifdef UBI_COIN
#include "api_ubi_coin.h"
#endif
#ifdef HMOTE2420
#include "api_hmote2420.h"
#endif
#ifdef	SKY_Z200
#include "api_sky_z200.h"
#endif
#ifdef TMOTE_SKY
#include "api_tmote_sky.h"
#endif
#ifdef TEST_PLATFORM
#include "api_device_driver.h"
#include "api_test_platform.h"
#endif
#ifdef OCTACOMM_SHIB
#include "api_octacomm_shib.h"
#include "api_device_driver.h"
#endif

//---- Atmega128 only-----//
#ifdef EEPROM_M
#include "eeprom.h"
#define eeprom_write_byte(addr, byte)		nos_eeprom_write_byte(addr, byte)	//void nos_eeprom_write_byte(UINT16 addr, UINT8 data)
#define eeprom_read_byte(addr)			nos_eeprom_read_byte(addr)	//UINT8 nos_eeprom_read_byte(UINT16 addr)
#define eeprom_write_block(addr, buf, len)	nos_eeprom_write_block(addr, buf, len)	//void nos_eeprom_write_block(const UINT16 addr, const UINT8 *buf, UINT16 len)
#define eeprom_read_block(addr, buf, len)	nos_eeprom_read_block(addr, buf, len)	//void nos_eeprom_read_block(UINT16 addr, UINT8 *buf, UINT16 len)
#endif
//---- Atmega128 only-----//


#ifdef BAT_POWER_M
#include "bat_power.h"
#define bat_get_data()			nos_bat_get_data()//UINT16 nos_bat_get_data(void)
#endif

#ifdef ACTUATOR_M
#include "actuator.h"
#define actuator_on(id)			NOS_ACTUATOR_ON(id)
#define actuator_off(id)		NOS_ACTUATOR_OFF(id)
#endif

#endif	//~API_H
