#include "sht11.h"

#ifdef SHT11_M

DrvI2cFuncList sht11_func;

UINT8 sensor_type = MEASURE_TEMP;
UINT8 sht11_func_connect(void)
{
	nos_uart_puts(STDOUT, "sht11_func_connect \n");

	sht11_func.init = sht11_init;
	sht11_func.read = sht11_data_read;
	sht11_func.set_type = sht11_set_sensor_type;

	deviceDriver[SHT11].drv_name = "sht11";
	deviceDriver[SHT11].drv_func_pport.power_on = sht11_power_on;
	deviceDriver[SHT11].drv_func_pport.power_off = sht11_power_off;

	deviceDriver[SHT11].drv_func_i2c = &sht11_func;
	deviceDriver[SHT11].drv_func_intr = NULL;
	deviceDriver[SHT11].drv_func_adc = NULL;
//	deviceDriver[SHT11].drv_func_spi = NULL;
	return 0;
}

UINT8 sht11_set_sensor_type(UINT8 type)
{
	nos_uart_puts(STDOUT, "sht11_set_sensor_type \n");
	if(type == 1)
	{
		nos_uart_puts(STDOUT, "MEASURE_TEMP \n");
		type = MEASURE_TEMP;
	}
	else if(type == 2)
	{
		nos_uart_puts(STDOUT, "MEASURE_HUM \n");
		type = MEASURE_HUM;
	}

	if(type == MEASURE_TEMP || type == MEASURE_HUM)
		sensor_type = type;
	else
		return 1;

	return 0;
}

UINT8 sht11_get_sensor_type(void)
{
	nos_uart_puts(STDOUT, "sht11_get_sensor_type \n");
	return sensor_type;
}

float sht11_read_sensor_data(UINT8 fd)
{
	nos_uart_puts(STDOUT, "sht11_read_sensor_data is \n");
	INT8 k = 0;
	UINT16 data;
	UINT8 cal_crc=0;

	hal_i2c_data_port_output(fd);	
	hal_i2c_data_port_high(fd);
	
	hal_i2c_sck_port_high(fd);
	
	hal_i2c_data_port_low(fd);
	
	nos_delay_us(2);
	hal_i2c_sck_port_low(fd);
	nos_delay_us(2);
	hal_i2c_sck_port_high(fd);


	hal_i2c_data_port_high(fd);

	nos_delay_us(2);
	hal_i2c_sck_port_low(fd);
	nos_delay_us(2);


	//-----------------------------------------------------
	// Transmission Command 	
	for(k = 7; k > -1 ; k--)
	{

		if((sensor_type >> k) & 0x01)
		  	hal_i2c_data_port_high(fd);
	  	else
		  	hal_i2c_data_port_low(fd);

		nos_delay_us(2);
		hal_i2c_sck_port_high(fd);
		nos_delay_us(2);
		hal_i2c_sck_port_low(fd);
	}

  	hal_i2c_data_port_input(fd);
	nos_delay_us(2);

	hal_i2c_sck_port_high(fd);
	while(hal_i2c_data_port_read_bit(fd));
	
	hal_i2c_sck_port_low(fd);

	nos_delay_ms(1);

	//-----------------------------------------------------
	// Read Hum or Temp Value
	data = 0; //integer

	while(hal_i2c_data_port_read_bit(fd));

	for(k = 7; k > -1;k--)
	{
		data = data << 1;
		nos_delay_us(2);
		hal_i2c_sck_port_high(fd);
		data = (data | hal_i2c_data_port_read_bit(fd));
		nos_delay_us(2);
		
		hal_i2c_sck_port_low(fd);
	}
	
	hal_i2c_data_port_output(fd);
	hal_i2c_data_port_low(fd);
	nos_delay_us(2);
	hal_i2c_sck_port_high(fd);
	nos_delay_us(2);
	hal_i2c_sck_port_low(fd);

	hal_i2c_data_port_input(fd);

	for(k = 7; k > -1;k--)
	{
		data = data << 1;
		nos_delay_us(2);
		hal_i2c_sck_port_high(fd);
		data = (data | hal_i2c_data_port_read_bit(fd));
		nos_delay_us(2);
		
		hal_i2c_sck_port_low(fd);
	}

	data <<= 2;
	
	hal_i2c_data_port_output(fd);
	hal_i2c_data_port_low(fd);
	nos_delay_us(2);
	hal_i2c_sck_port_high(fd);
	nos_delay_us(2);
	hal_i2c_sck_port_low(fd);

	hal_i2c_data_port_input(fd);

	//-----------------------------------------------------
	// Read CRC
	cal_crc = 0;

	for(k = 7; k > -1;k--)
	{
		cal_crc = cal_crc << 1;
		nos_delay_us(2);
		hal_i2c_sck_port_high(fd);
		cal_crc = (cal_crc | hal_i2c_data_port_read_bit(fd));
		nos_delay_us(2);
		
		hal_i2c_sck_port_low(fd);
	}
	cal_crc <<= 2;
	
	hal_i2c_data_port_output(fd);
	hal_i2c_data_port_high(fd);
	nos_delay_us(2);
	hal_i2c_sck_port_high(fd);
	nos_delay_us(2);
	hal_i2c_sck_port_low(fd);
	
	hal_i2c_data_port_output(fd);
	hal_i2c_sck_port_low(fd);
	hal_i2c_data_port_high(fd);

	if(sensor_type == 0x03)
		return data/1000.0;
	else
		return data/100.0;

} // Measurement

void sht11_write_status_reg(UINT8 fd, UINT8 reg)
{
	nos_uart_puts(STDOUT, "sht11_write_status_reg \n ");
	INT8 k=0;
	UINT8 command;

	command = WR_STATUS_REG;

	hal_i2c_data_port_output(fd);
	hal_i2c_data_port_high(fd);

	hal_i2c_sck_port_high(fd);

	hal_i2c_data_port_low(fd);

	nos_delay_us(2);
	hal_i2c_sck_port_low(fd);
	nos_delay_us(2);
	hal_i2c_sck_port_high(fd);

	hal_i2c_data_port_high(fd);

	nos_delay_us(2);
	hal_i2c_sck_port_low(fd);
	nos_delay_us(2);

	for(k=7;k>-1;k--)
	{
		if((command >> k) & 0x01)
			hal_i2c_data_port_high(fd);
		else
			hal_i2c_data_port_low(fd);

		hal_i2c_sck_port_high(fd);
		nos_delay_us(2);
		hal_i2c_sck_port_low(fd);
	}

	hal_i2c_data_port_input(fd);
	nos_delay_us(2);

	while(hal_i2c_data_port_read_bit(fd));

	hal_i2c_sck_port_high(fd);

	hal_i2c_data_port_output(fd);

	nos_delay_us(2);

	hal_i2c_sck_port_low(fd);
	nos_delay_us(2);

	for(k=7;k>-1;k--)
	{
		if((reg >> k) & 0x01)
			hal_i2c_data_port_high(fd);
		else
			hal_i2c_data_port_low(fd);

		hal_i2c_sck_port_high(fd);
		nos_delay_us(2);
		hal_i2c_sck_port_low(fd);
	}

	hal_i2c_data_port_input(fd);
	nos_delay_us(2);

	while(hal_i2c_data_port_read_bit(fd));
	hal_i2c_sck_port_high(fd);

	hal_i2c_data_port_output(fd);
	hal_i2c_sck_port_low(fd);
	hal_i2c_data_port_high(fd);

	return;
}

UINT8 sht11_read_status_reg(UINT8 fd)
{
	nos_uart_puts(STDOUT, "sht11_read_status_reg \n ");
	INT8 k=0;
	UINT8 reg;
	UINT8 cal_crc;
	UINT8 command;

	command = RD_STATUS_REG; // 0x07

	hal_i2c_data_port_output(fd);
	hal_i2c_data_port_high(fd);

	hal_i2c_sck_port_high(fd);
	
	hal_i2c_data_port_low(fd);
	
	nos_delay_us(2);
	hal_i2c_sck_port_high(fd);
	nos_delay_us(2);
	hal_i2c_sck_port_high(fd);


	hal_i2c_data_port_high(fd);

	nos_delay_us(2);
	hal_i2c_sck_port_high(fd);
	nos_delay_us(2);

	
	for(k = 7; k > -1 ; k--)
	{

		if((command >> k) & 0x01)
		  	hal_i2c_data_port_high(fd);
	  	else
		  	hal_i2c_data_port_low(fd);

		hal_i2c_sck_port_high(fd);
		nos_delay_us(2);
		hal_i2c_sck_port_high(fd); 
	}


// modify by huy.  06.09.14
	hal_i2c_data_port_output(fd);
	hal_i2c_data_port_low(fd);
	nos_delay_us(2);
	hal_i2c_sck_port_high(fd);
	nos_delay_us(2);
	hal_i2c_sck_port_high(fd);

	hal_i2c_data_port_input(fd);

	nos_delay_ms(1);

	reg = 0;

	for(k = 7; k > -1;k--)
	{
		reg = reg << 1;
		nos_delay_us(2);
		hal_i2c_sck_port_high(fd);
		reg = (reg | hal_i2c_data_port_read_bit(fd));
		nos_delay_us(2);
		
		hal_i2c_sck_port_high(fd);
	}
	reg <<= 2;
	
	hal_i2c_data_port_output(fd);
	hal_i2c_data_port_low(fd);
	nos_delay_us(2);
	hal_i2c_sck_port_high(fd);
	nos_delay_us(2);
	hal_i2c_sck_port_high(fd);

	hal_i2c_data_port_input(fd);

	//-----------------------------------------------------
	// Read CRC
	cal_crc = 0;

	for(k = 7; k > -1;k--)
	{
		cal_crc = cal_crc << 1;
		nos_delay_us(2);
		hal_i2c_sck_port_high(fd);
		cal_crc = (cal_crc | hal_i2c_data_port_read_bit(fd));
		nos_delay_us(2);
		
		hal_i2c_sck_port_high(fd);
	}
	cal_crc <<= 2;
	
	hal_i2c_data_port_output(fd);
	hal_i2c_data_port_high(fd);
	nos_delay_us(2);
	hal_i2c_sck_port_high(fd);
	nos_delay_us(2);
	hal_i2c_sck_port_high(fd);
	
	hal_i2c_data_port_output(fd);
	hal_i2c_sck_port_high(fd);
	hal_i2c_data_port_high(fd);

	return reg;	  		

} // ReadStatusReg

UINT8 sht11_init(UINT8 fd)
{
	nos_uart_puts(STDOUT, "sht11_init \n ");
	hal_i2c_sck_port_init(fd);
	return hal_pport_init(fd);
}

void sht11_data_port_init(UINT8 fd)
{
	nos_uart_puts(STDOUT, "sht11_data_port_init \n ");
	hal_i2c_data_port_output(fd);
	hal_i2c_data_port_high(fd);

	sht11_write_status_reg(fd, 0);

	return;
}

UINT8 sht11_power_on(UINT8 fd)
{
	nos_uart_puts(STDOUT, "sht11_power_on \n ");
	sht11_data_port_init(fd);
	return hal_pport_on(fd);
}

UINT8 sht11_power_off(UINT8 fd)
{
	nos_uart_puts(STDOUT, "sht11_power_off \n ");
	return hal_pport_off(fd);
}

float sht11_data_read(UINT8 fd)
{	
	nos_uart_puts(STDOUT, "sht11_data_read \n ");
	return sht11_read_sensor_data(fd);
}

void sht11_print_dev_name(UINT8 fd)
{
	nos_uart_puts(STDOUT, "sht11_print_dev_name \n ");
	nos_uart_puts(STDOUT, hal_get_dev_name(fd));
	nos_uart_puts(STDOUT, "\n");

	return;
}

UINT8 sht11_write_command(UINT8 fd, UINT8 command)
{
	UINT8 result = 0;
	switch(command)
	{
	case COMMAND_TEMP:
		result |= sht11_set_sensor_type(MEASURE_TEMP);
		break;
	case COMMAND_HUM:
		result |= sht11_set_sensor_type(MEASURE_HUM);
		break;
	default: break;
	}
	return result;
}
#endif
