#include "re200b.h"
#include "device_driver.h"
#ifdef RE200B_M

DrvIntrFuncList re200b_func;

UINT8 re200b_func_connect(void)
{
	re200b_func.init = re200b_init;
	re200b_func.register_cb_func = re200b_register_callback_func;

	deviceDriver[RE200B].drv_name = "re200b";
	deviceDriver[RE200B].drv_func_pport.power_on = re200b_power_on;
	deviceDriver[RE200B].drv_func_pport.power_off = re200b_power_off;
	
	deviceDriver[RE200B].drv_func_intr = &re200b_func;
	deviceDriver[RE200B].drv_func_adc = NULL;
	deviceDriver[RE200B].drv_func_i2c= NULL;
	
	return 0;
}

UINT8 re200b_callback_test(UINT8 fd, void (*func)(void))
{
	uart_printf("\n re200b_callback_test \n");
	re200b_func.register_cb_func(fd, func);

	return 0;
}

UINT8 re200b_init(UINT8 fd)
{
	uart_printf("\n re200b_init \n");
	UINT8 flag = 0;
	flag |= hal_interrupt_mask_setting(fd);
	flag |= hal_interrupt_enable_state_setting(fd, FALLING_EDGE);
	flag |= hal_pport_init(fd); 
	return flag;
}

UINT8 re200b_power_on(UINT8 fd)
{
	uart_printf("\n re200b_power_on \n");
	return hal_pport_on(fd);
}

UINT8 re200b_power_off(UINT8 fd)
{
	uart_printf("\n re200b_power_off \n");
	return hal_pport_off(fd);
}

UINT8 re200b_register_callback_func(UINT8 fd, void (*func)(void))
{

	uart_printf("\n re200b_register_callback_func \n");
	return hal_register_interrupt_callback_func(fd, func);
}

#endif
