//===================================================================
//
// cc2420.c (@jun361, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "cc2420.h"

#ifdef CC2420_M
#include "platform.h"
#include "spi.h"

void cc2420_init()
{
	UINT8 spiStatusByte;
	CC2420_RESET();		// reset CC2420, main registers
	CC2420_STROBE(CC2420_SXOSCON); // crystal oscillator on strobe

	// Poll the SPI status byte until the crystal oscillator is stable
	// wait for the crystal oscillator to become stable
	do {
		CC2420_UPD_STATUS(spiStatusByte);
	} while (!(spiStatusByte & (1 << CC2420_XOSC16M_STABLE)));
}

void cc2420_channel_init(UINT8 channel) // set to 26 (the last channel number) in apps
{
	UINT16 f;
	if (channel < 11 || channel > 26)
		channel = 11;
	// Derive frequency programming from the given channel number
	f = (UINT16) (channel - 11); 	// Subtract the base channel 
	f = f + (f << 2);    	 	// Multiply with 5, which is the channel spacing
	f = f + 357 + 0x4000;	 	// 357 is 2405-2048, 0x4000 is LOCK_THR = 1
	CC2420_SETREG(CC2420_FSCTRL, f); // Write it to the CC2420
}

#endif // CC2420_M
