#include <string.h>
#include "nos.h"
#include "device_driver.h"
#include "platform.h"

static INT16 index = 0;
TD pTDT[LENGTH_TDT] ; 

TD* Get_TD(INT8* name)
{
	INT16 i = 0 ; 
	while(pTDT[i].index < LENGTH_TDT+1)
	{	
		if(strcmp(name, pTDT[i].device_name) == 0 )
		{
			return &pTDT[i] ; 
		}	
		i++ ; 
	}
	 return 0; 
}

INT16 device_connect(INT8 *device_name,INT8 *device_type,INT8 *device_function)
{
	uart_printf(" device_connect index %d \n", index);
	pTDT[index].index = index;
	pTDT[index].type = device_type_index(device_type);
	pTDT[index].device_name = device_name;
	pTDT[index].func_pt = device_function_list(device_function);
	uart_printf(" %s \t %s \n",device_function, pTDT[index].func_pt.drv_name);

	index++;
	return index-1;
}

DrvFuncList device_function_list(INT8 *device_function)
{
	uart_printf(" device_function_list \n");
	for( INT16 i =0; i < SENSOR_DRIVER_MAX; i++)
	{
		if(strcmp(device_function,deviceDriver[i].drv_name) == 0)
		{
			uart_printf(" %s \t %s \n",device_function, deviceDriver[i].drv_name);
			return deviceDriver[i];
		}
	}

//	return 0;
}

INT16 device_type_index(INT8 *device_type)
{
	uart_printf(" device_type_index \n");

	INT16 nDevice_type = 0;

	for( INT16 i =0; i < SENSOR_DRIVER_MAX; i++)
	{
		if(strcmp(device_type,nos_mappingTable[i].dev_name) == 0)
		{
			nDevice_type = i;
			return nDevice_type;
		}
	}
	return -1;
}

void Open(INT16 fd)
{
	uart_printf(" Sensor init fd %d \t fd.type %d \n", fd, pTDT[fd].type);
	if ( pTDT[fd].func_pt.drv_func_adc != NULL)
	{
		uart_printf(" drv_func_adc \n");
		(*pTDT[fd].func_pt.drv_func_adc->init)(pTDT[fd].type) ; 
	}
	else if ( pTDT[fd].func_pt.drv_func_intr != NULL)
	{
		uart_printf(" drv_func_intr \n");
		(*pTDT[fd].func_pt.drv_func_intr->init)(pTDT[fd].type) ; 
	}
	else if ( pTDT[fd].func_pt.drv_func_i2c != NULL) 
	{
		uart_printf(" drv_func_i2c \n");
		(*pTDT[fd].func_pt.drv_func_i2c->init)(pTDT[fd].type) ; 
	}
	else
	{ 
		uart_printf(" Nothings \n");	
		// Nothing
	}
		
}

void Close(INT16 fd)
{	
//	(*pTDT[fd].func_pt.drve_func_adc->Close)();
}

float Read(INT16 fd)
{	
	uart_printf(" Read \n");
	if ( pTDT[fd].func_pt.drv_func_adc != NULL)
	{
		uart_printf(" drv_func_adc \n");
		return (*pTDT[fd].func_pt.drv_func_adc->read)(pTDT[fd].type);
	}
	else if ( pTDT[fd].func_pt.drv_func_i2c != NULL)
	{
		uart_printf(" drv_func_i2c \n");
		uart_printf("data %f ",(*pTDT[fd].func_pt.drv_func_i2c->read)(pTDT[fd].type) );
		return (*pTDT[fd].func_pt.drv_func_i2c->read)(pTDT[fd].type);
	}
}

void Write(INT16 fd, UINT8 CM)
{	
	uart_printf(" Write %d\n", CM);
	if ( pTDT[fd].func_pt.drv_func_i2c != NULL)
	{
		int test = (*pTDT[fd].func_pt.drv_func_i2c->set_type)(CM);
		uart_printf(" Write %d\n",test);
	}
}

void Ioctl(INT16 fd, INT16 funcType, INT16 Control, void (*func)(void))
{
	switch(funcType)
	{
		case 0: // Power
			switch(Control)
			{
				case 0:
					uart_printf(" Power Off \n");
					(*pTDT[fd].func_pt.drv_func_pport.power_off)(pTDT[fd].type) ; 
				break;
				case 1:
					uart_printf(" Power ON \n");
					(*pTDT[fd].func_pt.drv_func_pport.power_on)(pTDT[fd].type) ; 
				break;
			}
			break;
		case 1:	// Inturrupt
			switch(Control)
			{
				case 0:
	//				(*pTDT[fd].func_pt.drv_func_intr.register_cb_func)(func) ; 
					uart_printf(" Interrupt Off \n");
				break;
				case 1:
					uart_printf(" Interrupt ON \n");
					(*pTDT[fd].func_pt.drv_func_intr->register_cb_func)(pTDT[fd].type, func); 
				break;
			}
			
			break;
//		case 2:

//			break;
//		case 3:

//			break;
	}

	
}



void init_tdt(void)
{
	INT16 i = 0;
	for(i = 0; i < LENGTH_TDT; i++)
	{
		pTDT[i].index = LENGTH_TDT+1;
	}
}




#ifdef DEVICE_DRIVER_M
/*
#ifdef UART_M
#include "uart.h"
#include "intr.h"
#include "platform.h"
#endif
*/

//DrvFuncList deviceDriver[SENSOR_DRIVER_MAX];

#endif //DEVICE_DRIVER_M
