//===================================================================
//
// uart_putu.c (@sheart)
// Description : UINT8, UINT16 print
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "uart.h"

#ifdef UART_M
#include <stdlib.h>
#include "arch.h"
#include "critical_section.h"

extern INT8 pBuf[8];

void nos_uart_putu(UINT8 port_num, UINT16 val)
{
NOS_ENTER_CRITICAL_SECTION();
        utoa(val, pBuf, 10);
        nos_uart_puts(port_num, pBuf);
NOS_EXIT_CRITICAL_SECTION();
}

#endif
