//===================================================================
//
// spi.h	(@haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef SPI_H
#define SPI_H
#include "common.h"


// SPI configuration for RF chip
// -SW reset, 8bit transfer, SPI master, Data on Rising Edge, SMCLK, 3 wire, SIMO, CLK, CSn as output
#ifdef SPI_PORT0
#define SPI_TX_REG	U0TXBUF
#define SPI_RX_REG	U0RXBUF
#define	SPI_WAITFOREOTx()	while ((U0TCTL & TXEPT) == 0)  // USART0 Tx buffer ready? 
#define	SPI_WAITFOREORx()	while ((IFG1 & URXIFG0) == 0)  // USART0 Rx buffer ready?
#define SPI_INIT() \
do { \
	_BIT_CLR(P3SEL, UTXD0);		\
	_BIT_CLR(P3SEL, URXD0);		\
	U0CTL = CHAR + SYNC + MM + SWRST; 	\
	U0TCTL = CKPH + SSEL1 + STC; 		\
	U0CTL &= ~0x20;				\
						\
	U0BR0 = 0x02; 				\
	U0BR1 = 0; 				\
	U0MCTL = 0; 				\
						\
	ME1 &= ~(UTXE0 | URXE0);		\
	ME1 |= USPIE0;				\
	U0CTL &= ~SWRST;			\
						\
	IFG1 &= ~(UTXIFG0 | URXIFG0);		\
	IE1 &= ~(UTXIE0 | URXIE0);		\
} while (0)

#elif SPI_PORT1
#define SPI_TX_REG	U1TXBUF
#define SPI_RX_REG	U1RXBUF
#define	SPI_WAITFOREOTx()	while ((U1TCTL & TXEPT) == 0)  // USART1 Tx buffer ready? 
#define	SPI_WAITFOREORx()	while ((IFG2 & URXIFG1) == 0)  // USART1 Rx buffer ready?
#define SPI_INIT() \
do { \
	_BIT_CLR(P3SEL, UTXD1);		\
	_BIT_CLR(P3SEL, URXD1);		\
	U1CTL = CHAR + SYNC + MM + SWRST; 	\
	U1TCTL = CKPH + SSEL1 + STC; 		\
	U1CTL &= ~0x20;				\
						\
	U1BR0 = 0x02; 				\
	U1BR1 = 0; 				\
	U1MCTL = 0; 				\
						\
	ME2 &= ~(UTXE1 | URXE1);		\
	ME2 |= USPIE1;				\
	U1CTL &= ~SWRST;			\
						\
	IFG2 &= ~(UTXIFG1 | URXIFG1);		\
	IE2 &= ~(UTXIE1 | URXIE1);		\
} while (0)
#endif


// SPI: Low level functions
//      x = value (BYTE or WORD)
//      p = pointer to the byte array to operate on
//      c = the byte count
#define SPI_TX(x) \
    do { \
        SPI_TX_REG = x; \
        SPI_WAITFOREOTx(); \
    } while (0)

#define SPI_RX(x) \
    do { \
        SPI_TX_REG = 0; \
        SPI_WAITFOREORx(); \
        x = SPI_RX_REG; \
    } while (0)

#define SPI_RX_GARBAGE() \
    do { \
        SPI_TX_REG = 0; \
        SPI_WAITFOREORx(); \
        SPI_RX_REG; \
    } while (0)

#define SPI_TX_WORD_LE(x) \
    do { \
        SPI_TX(x); \
        SPI_TX((x) >> 8); \
    } while (0)
    
#define SPI_TX_WORD(x) \
    do { \
        SPI_TX(((UINT16)(x)) >> 8); \
        SPI_TX((UINT8)(x)); \
    } while (0)
    
#define SPI_TX_MANY(p,c) \
    do { \
        for (UINT8 spiCnt=0; spiCnt < (c); spiCnt++) { \
            SPI_TX(((UINT8*)(p))[spiCnt]); \
        } \
    } while (0)
        
#define SPI_RX_WORD_LE(x) \
    do { \
        SPI_TX_REG = 0; \
        SPI_WAITFOREORx(); \
        x = SPI_RX_REG; \
        SPI_TX_REG = 0; \
        SPI_WAITFOREORx(); \
        x |= SPI_RX_REG << 8; \
    } while (0)

#define SPI_RX_WORD(x) \
    do { \
        SPI_TX_REG = 0; \
        SPI_WAITFOREORx(); \
        x = SPI_RX_REG << 8; \
        SPI_TX_REG = 0; \
        SPI_WAITFOREORx(); \
        x |= SPI_RX_REG; \
    } while (0)
    
#define SPI_RX_MANY(p,c) \
    do { \
        for (UINT8 spiCnt=0; spiCnt < (c); spiCnt++) { \
            SPI_RX((p)[spiCnt]); \
        } \
    } while (0)

#endif // ~SPI_H
