//===================================================================
//
// pwr_mgr.h    (@haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef PWR_MGR_H
#define PWR_MGR_H

#include <stdio.h>
#define _BIS_SR(x)              __asm__ __volatile__("bis	%0, r2" : : "i" ((uint16_t) x))

#define NOS_IDLE		(0)
#define NOS_CPUOFF  	(0x0010)
#define NOS_OSCOFF  	(0x0020)
#define NOS_SCG0    	(0x0040)
#define NOS_SCG1    	(0x0080)
#define NOS_LPM0    	(NOS_CPUOFF)
#define NOS_LPM1    	(NOS_SCG0+NOS_CPUOFF)
#define NOS_LPM2    	(NOS_SCG1+NOS_CPUOFF)
#define NOS_LPM3    	(NOS_SCG1+NOS_SCG0+NOS_CPUOFF)
#define NOS_LPM4    	(NOS_SCG1+NOS_SCG0+NOS_OSCOFF+NOS_CPUOFF)

#define NOS_SET_SLEEP_MODE(sleep_mode)	\
	do 			\
	{	                \
	} 			\
	while(0)

#define NOS_SLEEP_MCU()				\
	do 					\
	{					\
		_BIS_SR(NOS_LPM0);  		\
	} 					\
	while(0)

#define NOS_SLEEP_ENABLE()			\
	do 					\
	{					\
	} 					\
	while(0)

#define NOS_SLEEP_DISABLE()			\
	do 					\
	{					\
	} 					\
	while(0)

#endif	// ~PWR_MGR_H
