//===================================================================
//                      
// intr.c (@haekim, @sheart)
//                      
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include <io.h>

#include "intr.h"
#include "critical_section.h"

#ifdef UART_M
#include "uart.h"
#include "platform.h"
#endif

volatile INTR_STATUS intr_status;

// Handles default interrupts (unexpected interrupts)
#ifdef UART_M
NAKED(_unexpected_)
{               
	NOS_DISABLE_GLOBAL_INTERRUPT();
	nos_uart_puts(STDOUT, "\n\rError! : An exception (Unexpected Interrupt) has occurred. Program was halted.");
	nos_uart_puts(STDOUT, "\n\rPlease check your program if interrupt handlers are installed properly.\n");
	while (1);
}
#endif

void nos_disable_interrupt()
{
        NOS_ENTER_CRITICAL_SECTION();
        if (intr_status.cnt == 0)
        {
		intr_status.ie1 = IE1;
		IE1 = 0;
		intr_status.ie2 = IE2;
		IE2 = 0;
		intr_status.ta = TACTL & TAIE;
		TACTL &= ~TAIE;
		intr_status.tb = TBCTL & TBIE;
		TBCTL &= ~TBIE;
		intr_status.i2c = I2CIE;
		I2CIE = 0;
		intr_status.compa = CACTL1 & CAIE;
		CACTL1 &= ~CAIE;
		intr_status.adc12 = ADC12IE;
		ADC12IE = 0;
		//intr_status.adc10 = ADC10CTL0 & ADC10IE;
		//ADC10CTL0 &= ~ADC10IE;
		intr_status.dac12 = DAC12_0CTL & DAC12IE;
		DAC12_0CTL &= ~DAC12IE;
        }
        ++intr_status.cnt;
        NOS_EXIT_CRITICAL_SECTION();
}

void nos_enable_interrupt()
{
        NOS_ENTER_CRITICAL_SECTION();
        if (intr_status.cnt != 0)
        {
                --intr_status.cnt;
                if ( intr_status.cnt == 0)
                {       
			IE1 = intr_status.ie1;
			IE2 = intr_status.ie2;
			TACTL |= intr_status.ta; 
			TBCTL |= intr_status.tb; 
			I2CIE = intr_status.i2c;
			CACTL1 |= intr_status.compa;
			ADC12IE = intr_status.adc12;
			//ADC10CTL0 |= intr_status.adc10;
			DAC12_0CTL |= intr_status.dac12;
                }
        }
        NOS_EXIT_CRITICAL_SECTION();
}


