//===================================================================
//
// critical_section.h (@msyu)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef CRITICAL_SECTION_H
#define CRITICAL_SECTION_H
#include "common.h"
#include "intr.h"

extern volatile UINT8 nested_intr_cnt;		// the number of cli() or sli() that is called
extern volatile INTR_STATUS intr_status;

#define NOS_ENTER_CRITICAL_SECTION() \
do { \
	NOS_DISABLE_GLOBAL_INTERRUPT(); \
	++nested_intr_cnt; \
} while (0)

#define NOS_EXIT_CRITICAL_SECTION() \
do { \
	--nested_intr_cnt; \
	if (!nested_intr_cnt) \
		NOS_ENABLE_GLOBAL_INTERRUPT(); \
} while (0)

#define NOS_ENTER_ISR()		(++nested_intr_cnt)
#define NOS_EXIT_ISR()		(--nested_intr_cnt)

#define NOS_IS_CTX_SW_ALLOWABLE() ((!nested_intr_cnt)&&(!intr_status.cnt))

#endif	// CRITICAL_SECTION_H
