//===================================================================
//
// uart_putc.c (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include <avr/io.h>
#include "uart.h"

#ifdef UART_M

void nos_uart_putc(UINT8 port_num, INT8 byte)
{
	if ( port_num == 0 )
	{
		while(!(UCSR0A & (1 << UDRE0))); // wait until tx buffer is available
		UDR0 = byte; // send the data
	}
	else
	{
		while(!(UCSR1A & (1 << UDRE1))); // wait until tx buffer is available
		UDR1 = byte; // send the data
	}
}
#endif
