//===================================================================
//                                      
// nos_free.c (@jun361)         
//
// This code is modified from avr-libc 1.4.4
//===================================================================
#include <stdlib.h>
#include "heap.h"
#include "critical_section.h"

void nos_free(void *p)
{
        struct __freelist *fp1, *fp2, *fpnew;
        INT8 *cp1, *cp2, *cpnew;

        // ISO C says free(NULL) must be a no-op 
        if (p == 0) return;

        cpnew = p;
        cpnew -= sizeof(size_t);
        fpnew = (struct __freelist *)cpnew;
        fpnew->nx = 0;

        // Trivial case : if there's no freelist yet, our entry will be the only one on it.
        if (__flp == 0) {
                __flp = fpnew;
                return;
        }

       NOS_ENTER_CRITICAL_SECTION();
	// Now, find the position where our new entry belongs onto the freelist.  
	// Try to aggregate the chunk with adjacent chunks if possible.

        for (fp1 = __flp, fp2 = 0; fp1; fp2 = fp1, fp1 = fp1->nx) 
        {
                if (fp1 < fpnew) continue;

                cp1 = (INT8 *) fp1;
                fpnew->nx = fp1;

                if ((INT8 *)&(fpnew->nx) + fpnew->sz == cp1) // upper chunk adjacent, assimilate it 
                {
                        fpnew->sz += fp1->sz + sizeof(UINT16);
                        fpnew->nx = fp1->nx;
                }

                if (fp2 == 0) // new head of freelist 
                {
                        __flp = fpnew;
                        NOS_EXIT_CRITICAL_SECTION();

                        return;
                }

                break;
        }

        // Note that we get here either if we hit the "break" above, or if we fell off the end of the loop.  
        // The latter means we've got a new topmost chunk.  
        // Either way, try aggregating with the lower chunk if possible. 

        fp2->nx = fpnew;
        cp2 = (INT8 *) &(fp2->nx);
        if (cp2 + fp2->sz == cpnew) // lower junk adjacent, merge 
        {
                fp2->sz += fpnew->sz + sizeof(UINT16);
                fp2->nx = fpnew->nx;
        }

        NOS_EXIT_CRITICAL_SECTION();
}
