//===================================================================
//
// heap.h (@jun361, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef HEAP_H
#define HEAP_H
#include "kconf.h"
#include "common.h"


#define HEAP_START_ADDR		((UINT16)&__heap_start)  // _end is defined by linker script in avrgcc(avr5.x)
#define HEAP_GET_SIZE()		(_heap_end_addr - HEAP_START_ADDR)
#define NOS_HEAP_INIT() \
	do { \
		__brkval = 0; \
		__flp = NULL; \
		_heap_end_addr = RAMEND - SYSTEM_STACK_SIZE; \
	} while (0)

// by linker
extern INT8 __heap_start;
extern UINT16 _heap_end_addr;

struct __freelist
{
        UINT16 sz;
        struct __freelist *nx;
};

extern struct __freelist *__flp;       // freelist pointer (head of freelist)
extern INT8 *__brkval;    // first location not yet allocated. use for making new chunk

void    *nos_malloc(UINT16 size);
void    nos_free(void *ptr);

#endif  // ~HEAP_H
