#include "hal_thread.h"

#ifdef KERNEL_M
#include "arch.h"

// initialize stack
// This is necessary because a context should be placed in the stack when context switching.
// After context switching call, the thread with this stack will be executed starting from the function pointer (func)
// kkamagui thinking move to hal or not?
STACK_PTR nos_tcb_stack_init(void (*func)(void), STACK_PTR fos, UINT16 stack_size)
{
        STACK_PTR  sptr; // stack pointer
        UINT16  temp_addr;
#ifdef SWAPSTK_M
	STACK_PTR stack_bottom;
#endif
        sptr = (STACK_PTR)(fos + (stack_size-1)) ; // stack pointer(8bit) indicates the top of stack
#ifdef SWAPSTK_M
	stack_bottom = sptr;
#endif

        temp_addr  = (UINT16) func; // the starting address of the task

        // Initially we pushes the starting address of the task
	// As soon as context switching, this thread will go jump to the start address (function pointer) of this function.
        *sptr-- = (UINT8) temp_addr;            // PCL to be restored
        *sptr-- = (UINT8) (temp_addr >> 8);     // PCH to be restored

	// Insert fills 0x00, which is not used anywhere, into the stack.
        *sptr-- = (UINT8) 0x00;         // r1 = 0x00; push r1
        *sptr-- = (UINT8) 0x00;         // r0 = 0x00; push r0
        *sptr-- = (UINT8) 0x00;         // r2 = 0x00; push r2
        *sptr-- = (UINT8) 0x00;         // r3 = 0x00; push r3
        *sptr-- = (UINT8) 0x00;         // r4 = 0x00; push r4
        *sptr-- = (UINT8) 0x00;         // r5 = 0x00; push r5
        *sptr-- = (UINT8) 0x00;         // r6 = 0x00; push r6
        *sptr-- = (UINT8) 0x00;         // r7 = 0x00; push r7
        *sptr-- = (UINT8) 0x00;         // r8 = 0x00; push r8
        *sptr-- = (UINT8) 0x00;         // r9 = 0x00; push r9
        *sptr-- = (UINT8) 0x00;         // r10 = 0x00; push r10
        *sptr-- = (UINT8) 0x00;         // r11 = 0x00; push r11
        *sptr-- = (UINT8) 0x00;         // r12 = 0x00; push r12
        *sptr-- = (UINT8) 0x00;         // r13 = 0x00; push r13
        *sptr-- = (UINT8) 0x00;         // r14 = 0x00; push r14
        *sptr-- = (UINT8) 0x00;         // r15 = 0x00; push r15
        *sptr-- = (UINT8) 0x00;         // r16 = 0x00; push r16
        *sptr-- = (UINT8) 0x00;         // r17 = 0x00; push r17
        *sptr-- = (UINT8) 0x00;         // r18 = 0x00; push r18
        *sptr-- = (UINT8) 0x00;         // r19 = 0x00; push r19
        *sptr-- = (UINT8) 0x00;         // r20 = 0x00; push r20
        *sptr-- = (UINT8) 0x00;         // r21 = 0x00; push r21
        *sptr-- = (UINT8) 0x00;         // r22 = 0x00; push r22
        *sptr-- = (UINT8) 0x00;         // r23 = 0x00; push r23
        *sptr-- = (UINT8) 0x00;         // r24 = 0x00; push r23
        *sptr-- = (UINT8) 0x00;         // r25 = 0x00; push r23
        *sptr-- = (UINT8) 0x00;         // r26 = 0x00; push r26
        *sptr-- = (UINT8) 0x00;         // r27 = 0x00; push r27
        *sptr-- = (UINT8) 0x00;         // r28 = 0x00; push r28
        *sptr-- = (UINT8) 0x00;         // r29 = 0x00; push r29
        *sptr-- = (UINT8) 0x00;         // r30 = 0x00; push r30
        *sptr-- = (UINT8) 0x00;         // r31 = 0x00; push r31
	// SREG = 0x80; enables interrupt for context switching
        *sptr-- = (UINT8) 0x80;         // SREG ; push SREG

#ifdef SWAPSTK_M
	sptr = (STACK_PTR)RAMEND - (stack_bottom - sptr);
#endif
	return ((STACK_PTR) sptr);	// eos
}

#endif
