//===================================================================
//
// sched.h (@jun361, @sheart, @kkamagui, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef HAL_SCHED_H
#define HAL_SCHED_H
#include "kconf.h"
#ifdef KERNEL_M

#include "common.h"
#include "arch.h"
#include "intr.h"

// Schedule period. 32ms is the maximum period.
// SCHED_TICKS = Clock(Hz)/prescaler * SCHED_PEROID(ms)/1000(sec)-1
// Note that changing this value does not mean channging tick interrupt interval.
#ifdef SCHED_PERIOD_5
#define SCHED_TIMER_MS		5
#define SCHED_TICKS		(_SYSTEM_CLOCK/1600-1)
#elif SCHED_PERIOD_10
#define SCHED_TIMER_MS		10
#define SCHED_TICKS		(_SYSTEM_CLOCK/800-1)
#else	// SCHED_PERIOD_32
#define SCHED_TIMER_MS		32
#define SCHED_TICKS		(_SYSTEM_CLOCK/250-1)
#endif

#define SET_KERNEL_TIMER_FLAG()	do { TCNT3=SCHED_TICKS-1;while(!_IS_SET(ETIFR, OCF3A)); } while (0)

void nos_sched_hal_init(void);
void nos_sched_timer_start(void);

#endif // KERNEL_M
#endif // ~HAL_SCHED_H
