//===================================================================
//
// hal_sched.c (@haekim,@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "hal_sched.h"

#ifdef KERNEL_M
#include <avr/io.h>
#include <avr/interrupt.h>
#include "arch.h"
#include "intr.h"

void (*sched_callback)(void);	// this varable indicates the scheduler is working or not.

void nos_sched_hal_init()
{
	// CTC mode. No compare output (normal port operation). 
	// Timer clock = _SYSTEM_CLOCK/8 
	// COM3A = 00, COM3B = 00, COM3C = 00, WGM3[1:0] = 00
	TCCR3A = 0x00;
	// ICNC3 = 0, ICES3 =0, WGM3[3:2]=01, CS3[2:0] = 010 (clk/8)
	TCCR3B = (1 << WGM32)|(1 << CS31);

	// Set scheduling period
	OCR3A = (UINT16)SCHED_TICKS;

	sched_callback = NULL;
}

void nos_sched_timer_start()
{
	// Timer/Counter interrupt flag register setting 
	TCNT3 = 0;
	CLEAR_TIMER3_COMPA_vect();	// clear timer interrupt flag
	ENABLE_TIMER3_COMPA_vect();	//activate timer interrupt
}


ISR(TIMER3_COMPA_vect)
{
	// This ISR excute "context switch". Do not change 'nested_intr_cnt' value.
	//NOS_ENTER_ISR();
	if ( sched_callback )
		sched_callback();
	//NOS_EXIT_ISR();
}

#endif
