//===================================================================
//
// arch.h (@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef ARCH_H
#define ARCH_H
#include "kconf.h"

#include "common.h"

#if defined ETRI_SSN || NANO_24 || SKY_Z200 || TEST_PLATFORM || OCTACOMM_SHIB
#define _SYSTEM_CLOCK	8000000ul
#else
#define _SYSTEM_CLOCK	7372800ul
#endif

#ifndef RAMEND
#define RAMEND 0x10FF // 4KB SRAM
#endif
#ifdef SWAPSTK_M
#define DEFAULT_STACK_SIZE		100 // default initial stack size for registers, PC, SP, etc.
#define SYSTEM_STACK_SIZE		400// common stack size for running thread. Heap does not use this area.
#else
#define DEFAULT_STACK_SIZE		200 // default stack size, considering stack usage for all interrupts + some margin
#define SYSTEM_STACK_SIZE		DEFAULT_STACK_SIZE // system thread stack size. Heap does not use this area.
#endif

#define NOS_NOP() __asm__ volatile ("nop\n\t" ::)	//no-operation.

// Functions and Variables
void nos_arch_init(void);
void nos_delay_us(UINT16 timeout_usec);
void nos_delay_ms(UINT16 timeout_msec);

#endif // ~ARCH_H
