//===================================================================
//
// arch.c (@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include <avr/io.h>
#include <inttypes.h>
#include "arch.h"
#include "heap.h"
#include "critical_section.h"
#include "intr.h"
#include "timer.h"

#ifdef ADC_M
#include "adc.h"
#endif

#ifdef EEPROM_M
#include "eeprom.h"
#endif
#ifdef TIMECHK_M
#include "time_check.h"
#endif

extern volatile INTR_STATUS intr_status;

void nos_arch_init()
{
	nested_intr_cnt = 0;
	intr_status.cnt = 0;	

	NOS_HEAP_INIT(); //must be placed 1st line because other _init_* functions may allocate memory region.
	nos_timer_init(); // for 802.15.4 scheduler and local clock
#ifdef ADC_M
	nos_adc_init();
#endif
}

// runs an idle loop for [timeout]
// each function call delay is 15clock (1.875us)
// optimized for 8MHz clock
void nos_delay_us(UINT16 timeout_usec) 
{
	while (timeout_usec--)
	{
		NOS_NOP();
	}
} 
void nos_delay_ms(UINT16 timeout_msec)
{
	while (timeout_msec--)
	{
		nos_delay_us(999); 
	}
}

