//===================================================================
//
// teno_sink.c (@haekim)                                                               
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#include "nos.h"


#define MY_ID			0
#define MIN_PERMIT_ID	0
#define MAX_PERMIT_ID	19
#define CHANNEL		26
#define PAN_ADDR	312

UINT16 rx_data[NWK_MAX_PAYLOAD_SIZE/sizeof(UINT16)];	//102 byte long
UINT16 tx_data[NWK_MAX_PAYLOAD_SIZE/sizeof(UINT16)];
INT8 input_str[6];

//Receives string and toggles LEDs.
void rx_callback(void)
{
	UINT16 rx_src_id, parent_id, dest_id;
	UINT8 rx_data_length, rx_port, loop;
	led_toggle(3);
	teno_recv_from_nwk(&rx_src_id, &rx_port, &rx_data_length, rx_data, &parent_id, &dest_id);
	uart_puts("\n\r");
	loop = rx_src_id/10;
	while(--loop)
	{
		uart_puts("\t\t");	
	}
	uart_printf("RX : %u(%u,%u)", rx_src_id, parent_id, rx_data[0]);
}


void task1(void* args)
{
	UINT8 i, data_length, dest_addr;
	for (i =0; i<NWK_MAX_PAYLOAD_SIZE/sizeof(UINT16); ++i)
	{
		tx_data[i]=i;		// dummy data
	}
	data_length = NWK_MAX_PAYLOAD_SIZE;
	
	while (TRUE)
	{
		++tx_data[0];
		uart_printf("\nInput destination address : "
);
		uart_gets(input_str, sizeof(input_str));
		dest_addr = atoi(input_str);
		teno_send_to_node(dest_addr, 2, data_length, tx_data);
		led_toggle(2);		
	}
}

int main(void) 
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	// Initializing  [ Channel:0x0B~0x1A (11~26), PAN ID : 0x0000~0xfffE(0~65534), Node ID(MAC short address) : 0~65534] 
	teno_init(CHANNEL, PAN_ADDR, MY_ID);
	teno_set_rx_range(MIN_PERMIT_ID, MAX_PERMIT_ID);
	teno_set_rx_cb(rx_callback);
	teno_role_as_sink();
	uart_printf("RF Channel : %d\nPAN address: %u\nID : %d\nReceivable Range : %d ~ %d\n", 
				CHANNEL, PAN_ADDR, MY_ID, MIN_PERMIT_ID, MAX_PERMIT_ID);

	thread_create(task1, NULL, 0, PRIORITY_NORMAL);
	sched_start();

	return 0;
} // main
