//===================================================================
//
// teno_node.c (@haekim)                                                               
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#include "nos.h"

//====== Change these  ==========
#define MY_ID	10
#define TX_SLEEP_PERIOD	1	//sec
#define CHANNEL		26
#define PAN_ADDR	312
//==========================
#define MIN_PERMIT_ID	((MY_ID/10-1)*10)
#define MAX_PERMIT_ID	((MY_ID/10+1)*10+9)

UINT16 tx_data[NWK_MAX_PAYLOAD_SIZE/sizeof(UINT16)];
UINT16 rx_data[NWK_MAX_PAYLOAD_SIZE/sizeof(UINT16)];	//102 byte long


//Receives string and toggles LEDs.
void rx_callback(void)
{
	UINT16 rx_src_id, parent_id, dest_id;
	UINT8 rx_data_length, rx_port;
	led_toggle(3);
	teno_recv_from_nwk(&rx_src_id, &rx_port, &rx_data_length, rx_data, &parent_id, &dest_id);
	uart_printf("\n\t\tRX : %u(%u)", rx_src_id, rx_data[0]);
}


// TX thread 
void task1(void* args)
{
	UINT8 i;
	// dummy data
	for (i=0; i<NWK_MAX_PAYLOAD_SIZE/sizeof(UINT16); ++i)
	{
		tx_data[i]=i;
	}
	while (TRUE)
	{
		++tx_data[0];
		if (teno_send_to_sink(1, NWK_MAX_PAYLOAD_SIZE, tx_data))
		{
			led_toggle(2);
			uart_printf("\nTX(%u) done to sink.", tx_data[0]);
		}
		else
		{
			uart_printf("\n\tTX(%u) FAIL.", tx_data[0]);
		}
		thread_sleep_sec(TX_SLEEP_PERIOD);
	}
}

int main(void) 
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	// Initializing  [ Channel:0x0B~0x1A (11~26), PAN ID : 0x0000~0xfffE(0~65534), Node ID(MAC short address) : 0~255 ] 
	teno_init(CHANNEL, PAN_ADDR, MY_ID);
	teno_set_rx_range(MIN_PERMIT_ID, MAX_PERMIT_ID);
	teno_set_rx_cb(rx_callback);
	uart_printf("RF Channel : %d\nPAN address: %u\nID : %d\nReceivable Range : %d ~ %d\n", 
				CHANNEL, PAN_ADDR, MY_ID, MIN_PERMIT_ID, MAX_PERMIT_ID);

	thread_create(task1, NULL, 0, PRIORITY_NORMAL);
	sched_start();

	return 0;
} // main
