//===================================================================
//
// rf_overhead.c (@haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "nos.h"

NMAC_TX_INFO tx_info;
UINT8 tx_payload[NMAC_MAX_PAYLOAD_SIZE];	// Nano mac max payload : 116 byte

int main (void)
{
	INT8 uart_buf[7];
	UINT16 my_addr, pan_addr, dest_addr;
	UINT8 channel, payload_len, n;
	BOOL ack_request;
	
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	uart_puts("Channel (11~26) : ");
	uart_gets(uart_buf, 3);
	channel = (UINT8)(atoi(uart_buf));

	uart_puts("PAN address (1~65534) : ");
	uart_gets(uart_buf, 6);
	pan_addr = (UINT16)(atoi(uart_buf));

	uart_puts("My address (1~65534) : ");
	uart_gets(uart_buf, 6);
	my_addr = (UINT16)(atoi(uart_buf));

	uart_puts("Destination address (1~65534 or 65535[broadcast]) : ");
	uart_gets(uart_buf, 6);
	dest_addr = (UINT16)(atoi(uart_buf));

	uart_puts("Payload length (1~116) : ");
	uart_gets(uart_buf, 4);
	payload_len = (UINT8)(atoi(uart_buf));

	uart_puts("Ack request? (y/n) : ");
	uart_gets(uart_buf, 2);
	if (uart_buf[0] == 'y' || uart_buf[0] == 'Y')
		ack_request = TRUE;
	else
		ack_request = FALSE;

	tx_info.dest_addr = dest_addr;	// broadcast
	tx_info.payload_length 	= payload_len; // small packet makes more frequent NMAC_MAX_PAYLOAD_SIZE(116);
	tx_info.payload_ptr = tx_payload;

	// Write dummy data to tx_payload[1]~[114].
   	for (n = 0; n < NMAC_MAX_PAYLOAD_SIZE; n++) 
	{
		tx_payload[n] = n;
	}

	mac_init(channel, pan_addr, my_addr);	// channel=26, PAN id = 0x2420, source node id = 0x1234 (A)
	mac_rx_off();		// default : on (from mac_init)
						// ack packet can be received even if rf has been turned off.
	//mac_set_rx_cb(void (*func)(void)); // default : NULL. RX interrupt callback function
	//mac_set_rx_range(0x0000, 0xffff); // default (from mac_init)

	if (ack_request)
	{
	   	while (TRUE) 
	   	{
			++tx_payload[0];
			mac_tx(&tx_info);
		}
	}
	else
	{
	   	while (TRUE) 
	   	{
			++tx_payload[0];
			mac_tx_noack(&tx_info);
		}

	}

   	return 0;
} // main
