//===================================================================
//
// router22.c (@haekim)                                                               
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#include "nos.h"

// This node does nothing except forwarding (routing) in kernel mode.
void task1(void* args)
{
	while (TRUE)
	{
		print_local_clock();
		thread_sleep_ms(2000);
	}
}

int main(void) 
{
	UINT8 	channel = 26;
	UINT16 	pan_addr  = 312;	
	UINT8	node_id = 22;
//--------for multi-hop test --------------------
	UINT8 min_permit_id = 11;
	UINT8 max_permit_id = 39;
//---------------------------------------
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	// Initializing  [ Channel:0x0B~0x1A (11~26), PAN addr : 0x0000~0xfffE(0~65534), Node ID(MAC short address) : 0~255 ]
	nwk_init(channel, pan_addr, node_id, min_permit_id, max_permit_id);

	uart_printf("RF Channel : %d\nPAN address: %u\nID : %d\nReceivable Range : %d ~ %d\n", 
				channel, pan_addr, node_id, min_permit_id, max_permit_id);

	thread_create(task1, NULL, 0, PRIORITY_NORMAL);

 	sched_start();

	return 0;
} // main
