//===================================================================
//
// Max payload, Extream data flow Test
// tx.c (@haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#include "nos.h"

NMAC_TX_INFO tx_info;	// Simple mac Tx information
UINT8 tx_payload[NMAC_MAX_PAYLOAD_SIZE];	// Simple mac max payload : 115 byte

int main (void)
{
   	UINT8 n;
	
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	tx_info.dest_addr = 0x5678; // destination node id = 0x5678 (B)
	tx_info.payload_length 	= NMAC_MAX_PAYLOAD_SIZE; //116
	tx_info.payload_ptr = tx_payload;

	// Write dummy data to tx_payload[1]~[115].
   	for (n = 0; n < NMAC_MAX_PAYLOAD_SIZE; n++) 
	{
		tx_payload[n] = n;
	}

	mac_init(0x11, 0x2420, 0x1234);	// channel=26, PAN id = 0x2420, source node id = 0x1234 (A)
	//mac_set_rx_range(0x0000, 0xffff); // default (from mac_init)
	//mac_set_tx_power(31); //default
	//mac_rx_on();		// default : on (from mac_init)
						// ack packet can be received even if rf has been turned off.
	//nmac_set_rx_cb(void (*func)(void)); // default : NULL. RX interrupt callback function
	
   	while (TRUE) 
   	{
		// Sends packet. Requests autoack
		mac_tx(&tx_info);
		//++tx_payload[0];
	}
    	return 0;
} // main
