///========================================================================
// Copyright 2004-2010, ETRI
// Author : Haeyong Kim (haekim@etri.re.kr)
// Date : 2006.06.01
// File : mt_recv_str.c 
// Description : Receive string from the keyboard on multiple threads running mode.
//=========================================================================

#include "nos.h"

void task1(void *args)
{
	INT8 temp_str[2];
	uart_printf("Type 1 character for 'task1', and then press 'Enter'.\n");

	while (1)
	{
		uart_gets(temp_str, 2);
		uart_printf("[task1] You typed : %s. Type for next thread.\n", temp_str);
		thread_sleep(1);
	}
}

void task2(void *args)
{
	INT8 temp_str[3];
	uart_printf("Type 2 characters for 'task2', and then press 'Enter'.\n");

	while(1)
	{
		uart_gets(temp_str, 3);
		uart_printf("[task2] You typed : %s. Type for next thread.\n", temp_str);
		thread_sleep(1);
	}
}

void task3(void *args)
{
	INT8 temp_str[4];
	uart_printf("Type 3 characters for 'task3', and then press 'Enter'.\n");
	while (1)
	{
		uart_gets(temp_str, 4);
		uart_printf("[task3] You typed : %s. Type for next thread.\n", temp_str);
		thread_sleep(1);
	}
}

void task4(void *args)
{
	while (1)
	{
		led_on(1);
		led_off(2);
		led_off(3);
		delay_ms(50);
		led_off(1);
		led_on(2);
		led_off(3);
		delay_ms(50);
		led_off(1);
		led_off(2);
		led_on(3);
		delay_ms(50);
		led_off(1);
		led_off(2);
		led_off(3);
		thread_sleep(1);
	}
}


int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	thread_create(task1, NULL, 2, PRIORITY_NORMAL); 
	thread_create(task2, NULL, 3, PRIORITY_NORMAL);
	thread_create(task3, NULL, 4, PRIORITY_NORMAL);
	thread_create(task4, NULL, 0, PRIORITY_NORMAL);

	sched_start();

   	return 0;
}
