//===================================================================
//
// reno_pir.c (@haekim)                                                               
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#include "nos.h"

//------ Change here for testing ----------//
#define CHANNEL 12
#define PAN_ADDR 312
#define MY_ID 11
#define DEST_ID 12
//------ Change here for testing ----------//

// PIR interrupt handler, TX data
void pir_int_handler(void)
{
	UINT16 data;
	led_on(3);
	uart_puts("\r\n\tPIR Detected!\n\r");
	data = bat_get_data();
	nwk_tx(DEST_ID, 2, &data);	//send current battery power (2byte)
	led_off(3);
}

void task1(void* args)
{
	while (TRUE)
	{
		uart_putc(_BS);	
		uart_puts("-");
		thread_sleep(1);
		uart_putc(_BS);
		uart_puts("\\");
		thread_sleep(1);		
		uart_putc(_BS);		
		uart_puts("|");
		thread_sleep(1);		
		uart_putc(_BS);				
		uart_puts("/");
		thread_sleep(1);		
	}
}

// RX thread
void task2(void* args)
{
	UINT8 src_id;
	UINT8 length;
	UINT16 data[1];
	while (TRUE)
	{
		if ( nwk_rx(&src_id, &length, data) )
		{
			led_on(2);
			uart_printf("\nCurrent Voltage : %u.%u%u\n", data[0]/100, (data[0]%100)/10, (data[0]%100)%10 );
			led_off(2);
		}
		thread_sleep(1);
	}
}

int main(void) 
{
	UINT8 	channel = CHANNEL;
	UINT8 	node_id = MY_ID; 
	UINT16 	pan_id = PAN_ADDR;
	UINT8 	min_permit_id = 0; 
	UINT8 	max_permit_id = 255;

	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	// Initializing  [ Channel:0x0B~0x1A (11~26), PAN ID : 0x0000~0xfffE(0~65534), Node ID(MAC short address) : 0~255 ]	
	nwk_init(channel, pan_id, node_id, min_permit_id, max_permit_id);
 	uart_printf("RF Channel : %d PAN : %d ID : %d Receivable Range : %d ~ %d", channel, pan_id, node_id, min_permit_id, max_permit_id);

	pir_callback(pir_int_handler);
	pir_power_on();
	uart_puts("\r\n== PIR sensing exam ==\r\n");	
	led_on(1);
	
	thread_create(1, task1, NULL, 0, PRIORITY_NORMAL);
	thread_create(2, task2, NULL, 0, PRIORITY_NORMAL);
	sched_start();

	pir_power_off();
	return 0;
} // main
