//===================================================================
//
// reno_general.c (@haekim)                                                               
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#include "nos.h"



// TX
UINT8 dest_id, tx_length, n;
UINT8 tx_data[NWK_MAX_PAYLOAD_SIZE]; //108

// RX
UINT8 src_id, rx_length;
UINT8 rx_data[NWK_MAX_PAYLOAD_SIZE];

void command(UINT8 rx_char)
{

	if (rx_char == 'r' || rx_char == 'R')
	{
		if ( nwk_rx(&src_id, &rx_length, rx_data) )
		{
			uart_puts("\n\rRX : ");
			uart_putu( rx_data[0] );	// print out only the first byte of 115byte payload.
		}
		else
		{
			uart_puts("\n\rRX queue is empty");
		}
	}
	else if (rx_char == 't' || rx_char == 'T')
	{
		tx_data[0] = n;	// write the packet number to tx_payload[0]
		uart_printf("\nTX : %d", n++);
		nwk_tx(dest_id, 1, tx_data);
	}	
	else if (rx_char == '1')
		led_toggle(1);
	else if (rx_char == '2')
		led_toggle(2);
	else if (rx_char == '3')
		led_toggle(3);
}


//----------------- Dummy thread ------------------
void task1(void *args)
{
	while (TRUE) 
	{

	}
}

//----------------- Dummy thread ------------------
void task2(void *args)
{
	while (TRUE)
   	{

	}
}


int main(void) 
{
	UINT8 	channel = 0x0C;
	UINT8 	node_id = 1;
	UINT8 	min_permit_id = 0; 
	UINT8 	max_permit_id = 255;
	UINT16 	pan_id = 312;

	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	// Configuration
	INT8 tmp[10];
	do
	{
		uart_puts("\r\nEnter my RF Channel (11~26): ");
		uart_gets(tmp, 3);
		channel = atoi(tmp);
	}while (!( atoi(tmp) >= 11  && atoi(tmp) <=26 ));
	do
	{
		uart_puts("\rEnter my PAN ID (0~65534): ");
		uart_gets(tmp, 6);
		pan_id = atol(tmp);
	}while (!( atol(tmp) >= 0  && atol(tmp) <=65535 ));
	do
	{
		uart_puts("\rEnter my ID (0~255): ");
		uart_gets(tmp, 4);
		node_id = atoi(tmp);
	}while (!( atoi(tmp) >= 0  && atoi(tmp) <=255 ));
	uart_printf("\nThe range of receivable node id\n");
	do
	{
		uart_puts("\rMin (0~255): ");
		uart_gets(tmp, 4);
		min_permit_id = atoi(tmp);
	}while (!( atoi(tmp) >= 0  && atoi(tmp) <=255 ));
	do
	{
		uart_puts("\rMax (0~255): ");
		uart_gets(tmp, 4);
		max_permit_id = atoi(tmp);
	}while (!( atoi(tmp) >= 0  && atoi(tmp) <=255 ));
	do
	{
		uart_puts("\rEnter destinaion ID (0~255): ");
		uart_gets(tmp, 4);
		dest_id = atoi(tmp);
	}while (!( atoi(tmp) >= 0  && atoi(tmp) <=255 ));

	// Initializing  [ Channel:0x0B~0x1A (11~26), PAN ID : 0x0000~0xfffE(0~65534), Node ID(MAC short address) : 0~255 ]	
	nwk_init(channel, pan_id, node_id, min_permit_id, max_permit_id);
 	uart_printf("\n\nRF Channel : %d \nPAN address: %u \nID : %d \nReceivable Range : %d ~ %d\nDestination ID : %d\n", channel, pan_id, node_id, min_permit_id, max_permit_id, dest_id);
	n = 0;

	// UART interrupt callback fucntion registering
	uart_getc_callback(command);
	enable_uart_rx_intr();

	uart_printf("\nCommand : (T)x, (R)x or LED(1), LED(2), LED(3) toggle\n");

	thread_create(1, task1, NULL, 0, PRIORITY_NORMAL);
	thread_create(2, task2, NULL, 0, PRIORITY_NORMAL);

 	sched_start();

	return 0;
} // main
