//===================================================================
//
// mac_string.c (@haekim)
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#include "nos.h"

NMAC_TX_INFO txinfo;
INT8 txbuf[NMAC_MAX_PAYLOAD_SIZE]; // 115
NMAC_RX_INFO rxinfo;
INT8 rxbuf[NMAC_MAX_PAYLOAD_SIZE]; // 115
INT8 uart_buf[7]; // 115

//----------------- TX thread ------------------
void task1(void *args)
{

   	// Initalize COMMON protocol parameters
	txinfo.payload_ptr = txbuf;

	while (TRUE)
	{
		uart_puts("\r\nInput destination address(0~65534) or Broadcast(65535).\n\r");
		uart_gets(txbuf, 6); // Maximum of short address is 65535 --> 5 character + '\0' character.
		txinfo.dest_addr = atoi(txbuf); // destination node Id = 0x1---, 0xffff :broadcast.
		uart_putu(txinfo.dest_addr);
		
	   	
		// Receive string from keyboard.
		uart_puts("\n\rType anything, and then press 'Enter'.\n\r");

		uart_gets(txbuf, SPLMAC_MAX_PAYLOAD_SIZE);
		txinfo.payload_length = strlen(txbuf)+1;	// string + '\0' 

		//Transmit "txbuf" payload.
  		if (mac_tx(&txinfo)) // successful transmission (ack received)
		{
			uart_printf("\nSuccess to send : %s\n", (INT8*)txinfo.payload_ptr);
			//uart_printf("\nSuccess to send : %s\n", txbuf);
  		}
		else // No ACK received
		{
			uart_printf("\nFail to send : %s\n", (INT8*)txinfo.payload_ptr);
			//uart_printf("\nSuccess to send : %s\n", txbuf);
		}
    	} // while
}

//----------------- RX thread ------------------
void task2(void *args)
{
	rxinfo.payload_ptr = rxbuf;
        while (TRUE)
    	{
    		if ( mac_rx(&rxinfo) )
		{
			uart_printf("\n\rRecieved Packet (string) : %s\n", (INT8*)rxinfo.payload_ptr);
			//uart_printf("\n\rRecieved Packet (string) : %s\n", rxbuf);
		}
	}
}

//----------------- Dummy thread ------------------
void task3(void *args)
{
    while (TRUE)
    {
		thread_sleep_ms(1); // Force to swich context.
    }
}

int main (void) 
{
	UINT16 min_permit_addr, max_permit_addr;

	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");	

	uart_puts("Input my address.\n\r");
	uart_gets(uart_buf, 6); // Maximum of short address is 65534 --> 5 character + '\0' character.
	mac_init(12, 0x312, atoi(uart_buf)); // channel:0x0B~0x1A (11~26), PAN Id , short address(source node Id) = 0x0---
	//mac_rx_off();		// ack packet can be received even if rf has been turned off.

	uart_puts("Input the minimum RX address.\n\r");
	uart_gets(uart_buf, 6); // Maximum of short address is 65534 --> 5 character + '\0' character.
	min_permit_addr = atoi(uart_buf);
	uart_puts("Input the maximum RX address.\n\r");
	uart_gets(uart_buf, 6); // Maximum of short address is 65534 --> 5 character + '\0' character.
	max_permit_addr = atoi(uart_buf);
	mac_set_rx_range(min_permit_addr, max_permit_addr);

	thread_create(task1, NULL, 0, PRIORITY_NORMAL);
	thread_create(task2, NULL, 0, PRIORITY_NORMAL);
	thread_create(task3, NULL, 0, PRIORITY_NORMAL);
 	sched_start();

	return 0;	
} // main

