#!/bin/sh

echo "========== Check Prerequisite Software for NanoQplus ==========="
echo "- Cygwin -"
result=$(grep cygwin /Cygwin.bat | sed 's/chdir //g' | sed 's/\\bin//g')
echo "[Cygwin Home]="$result
result=$(which bash)
echo " [bash]="$result
result=$(which gcc)
echo " [gcc]="$result
result=$(which g++)
echo " [g++]="$result
result=$(which flex)
echo " [flex]="$result
result=$(which bison)
echo " [bison]="$result
result=$(which m4)
echo " [m4]="$result
result=$(which make)
echo " [make]="$result
result=$(which rxvt)
echo " [rxvt]="$result

echo ""
echo "- Compilers -"
result=$(which avr-gcc)
echo "[avr-gcc]="$result
if [ -z $result ]
then
	echo "- No avr-gcc installed."
fi
result=$(which msp430-gcc)
echo "[msp430-gcc]="$result
if [ -z $result ]
then
	echo "- No msp430-gcc installed."
fi

echo ""
echo "- NOS_HOME -"
echo "[NOS_HOME]=$NOS_HOME"
if [ -z $result ]
then
	echo "- NOS_HOME was not set. Please set it in /etc/qplusn, and do 'source ~/.bash_profile'"
fi
