<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */


/**
 * WBTreeView
 *
 * @package php.ui.winbinder
 */
class WBTreeView extends WBControl {
	/**
	 *  
	 * 
	 * @param array $options
	 */ 
	public function __construct($options = array()) { 
		$options['class'] = TreeView;

		parent::__construct($options);
	}

	/**
	 * ü  ʱȭ ޼ҵ  
	 * 
	 * line  üũѴ. 
	 * 
	 * @see lib/php/ui/winbinder/WBControl#initCreate()
	 */
	public function initCreate() { 
		parent::initCreate();

		if (!isset($this->line)) $this->line = true;
	}

	/**
	 * Component ʱȭ  
	 * 
	 * @see lib/php/ui/winbinder/WBControl#initComponent()
	 */
	public function initComponent() { 
		parent::initComponent();

		if (isset($this->line))		$this->setLine($this->line);
		if (isset($this->items))	$this->setItems($this->items);
	}

	/**
	 *   
	 *
	 * @return boolean 
	 */
	public function setLine($isLine = false) { 
		return $this->setStyle(WBC_LINES, $isLine);
	}

	/**
	 * Node  
	 * 
	 * <code>
	 * $options = array(
	 *		'caption' => '',
	 *		'value' => '',
	 *		'where' => '',
	 *		'image' => '',
	 *		'selectedimage' => '',
	 *		'insertiontype' => '',
	 * );
	 *
	 * </code>
	 * 
	 * @param array $opt 
	 * @return WBTreeNode 
	 */
	public function createNode($opt = array()) { 
		$arr = array(
			$opt['caption'],	
			isset($opt['value']) ? $opt['value'] : 0,	
			isset($opt['where']) ? $opt['where'] : 0,	
			isset($opt['image']) ? $opt['image'] : -1,	
			isset($opt['selectedimage']) ? $opt['selectedimage'] : -1,	
			isset($opt['type']) ? $opt['type'] : 0,	
		);

		return new WBTreeNode(array('tree' => $this, 'instance' => $this->createItems(array($arr))));
	}

	/**
	 * RootNode   
	 * 
	 * @param array $options
	 * @return WBTreeNode
	 */
	public function createRoot($options = array()) { 
		$options['type'] = 0;

		return $this->createNode($options);
	}

	/**
	 * õǾ TreeNode  
	 * 
	 * @return WBTreeNode
	 */
	public function selectedNode() { 
		return new WBTreeNode(array('tree' => $this, 'instance' => $this->getSelected()));
	}

	/**
	 * Tree ü   
	 * 
	 * @return boolean
	 */
	public function deleteNodeAll() { 
		return $this->deleteItems();
	}
}

?>