<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */


/**
 * WBToolBar
 *
 * @package php.ui.winbinder
 */
class WBToolBar extends WBControl { 

	public function __construct($options = array()) { 
		$options['class'] = ToolBar;

		parent::__construct($options);
	}

	public function initCreate() { 
		if ($this->image) { 
			$this->param = $this->image; 
		}

		if ($this->items) { 
			$temp = array();

			foreach ($this->items as $item) { 
				if (is_array($item)) { 
					if ($item['tooltip']) { 
						$item['parent'] = $this;
						$tempItem = new WBToolBarItem($item);

						$temp[] = $tempItem->getToolBarTemplate();
					} else { 
						$tempItem = new WBToolBarItem(array(
							'parent'	=> $this,
							'tooltip'	=> $item[2],	
							'image'		=> $item[3],	
						));

						$temp[] = $tempItem->getToolBarTemplate();
					}
				} else { 
					$temp[] = $item;
				}
			}

			$this->caption = $temp;
		}

		$this->id = 0;
		$this->style = 0;
		$this->x = 0;
		$this->y = 0;
		$this->width = 16;
		$this->height = 15;
	}
}

?>
