<?php

/**
 *
 * @package php.ui.winbinder
 */


/**
 * 쿡 Ǵ dll  ϱ  Ŭ 
 *
 * 
 * @package php.ui.winbinder
 */
class WBLibrary extends PObject { 
	
	private $_library = '';
	private static $_instance = null;

	/**
	 *  
	 *
	 * 
	 * @param string $library ý Ǵ ε ̺귯(dll) ̸ 
	 */
	public function __construct($library) { 
		$this->_library = $library;

		$this->load();
	}

	/**
	 * $_library  ϵ ̺귯 εѴ. 
	 * ̺귯 νϽ ѹ εȴ. 
	 *
	 */
	public function load() { 
		if ($GLOBALS['__library_list'][$this->_library]) { 
			$this->_instance = $GLOBALS['__library_list'][$this->_library];
		} else {
			$this->_instance = wb_load_library($this->_library);

			$GLOBALS['__library_list'][$this->_library] = $this->_instance;
		}
	
	}

	/**
	 * νϽ Լ    
	 * 
	 * @param string $func  Լ ̸ 
	 * @return int Լ  
	 */ 
	public function getFunction($func) { 
		if (!$GLOBALS['__win32_function_list'][strtolower($func)]) { 
			$addr = wb_get_function_address($func, $this->getInstance());

			$GLOBALS['__win32_function_list'][strtolower($func)] = $addr;
		}

		return $GLOBALS['__win32_function_list'][strtolower($func)];
	}

	/**
	 * ־ Լͷ Լ  
	 *
	 * @param string $func  Լ ̸ 
	 * @param array $args Ű Ʈ 
	 * @return mixed Լ  ϰ 
	 */ 
	public function call($func, $args = array()) { 
		return wb_call_function($this->getFunction($func), $args);
	}

	/**
	 * load ̺귯 νϽ  
	 *
	 * @return int νϽ  
	 */ 
	public function getInstance() { 
		return $this->_instance;
	}

	/**
	 * ε ̺귯  
	 *
	 * @return string ̺귯 
	 */
	public function getLibrary() { 
		return $this->_library;
	}

	/**
	 *    ޸ ּ()  
	 *
	 * @param string|int|bool|double $data Ÿ 
	 * @return int ޸ ּ 
	 */
	public static function getAddress($data) { 
		return wb_get_address($data);
	}

	/**
	 * ޸ ּҷκ Ÿ  
	 * 
	 * @param int $ptr ޸ ּ 
	 * @param int $bytes  Ʈ  
	 * @return mixed ޸  
	 */
	public static function get($ptr, $bytes = 0) {
		return wb_peek($ptr, $bytes);
	}

	/** 
	 * ޸ ּҿ   ϱ 
	 * 
	 * @param int $ptr ޸ ּ 
	 * @param string $contents  ڿ 
	 * @param int $bytes  Ʈ , 0 ü 
	 *
	 */
	public static function set($ptr, $contents, $bytes = 0){
		return wb_poke($ptr, $contents, $bytes);
	}

	/**
	 * Լ  ƿƼ ޼ҵ 
	 * 
	 * Լ ϴ  ü ϳ ޼ҵ Ѵ. 
	 *
	 * @param string $library ̺귯
	 * @param string $func Լ 
	 * @param array &$args Ű Ʈ 
	 * @return mixed Լ  
	 */
	public static function run($library, $func, $args = array()) { 
		$lib = new WBLibrary($library);
		return $lib->call($func, $args);
	}

	public static function send($wbobject, $message, $wparam, $lparam) { 
		return wb_send_message($wbobject, $message, $wparam, $lparam);
	}
}

/**
 * ε ̺귯 νϽ 
 *
 */
$GLOBALS['__library_list'] = array();
?>