<?php
/**
 * winbinder package 
 *
 * @package php.ui.winbinder
 */

/**
 * WBGraphics Ŭ 
 *
 * @package php.ui.winbinder 
 */ 
class WBGraphics extends PObject { 

	private $buffer = null;

	const LINE_SOLID			= 0;
	const LINE_DOTTED			= 1;
	const LINE_DASHES_2			= 2;
	const LINE_DASHES_3			= 3;
	const LINE_DASHES_4			= 4;
	const LINE_DASHES_5			= 5;
	const LINE_DASHES_6			= 6;
	const LINE_DASHES_7			= 7;
	const LINE_DASHES_DOTS		= 8;
	const LINE_DASHES_DOUBLE_DOTS = 9;

	const POS_LEFT		= WBC_LEFT;
	const POS_CENTER	=  WBC_CENTER;
	const POS_RIGHT		=  WBC_RIGHT;
	const POS_TOP		=  WBC_TOP;
	const POS_MIDDLE	=  WBC_MIDDLE;
	const POS_BOTTOM	=  WBC_BOTTOM;

	const MULTILINE		=  WBC_MULTILINE;
	const ELLIPSIS		=  WBC_ELLIPSIS;

	public function __construct($buffer) { 
		$this->buffer = $buffer;
	}

	/**
	 * target bitmap Ÿ ׸ 
	 *
	 * @param mixed $bitmap 
	 * @param int $x 
	 * @param int $y 
	 * @param int $width
	 * @param int $height 
	 * @param int $transparentcolor   
	 */
	public function image($bitmap, $x = 0, $y = 0, $width = 0, $height = 0, $transparentcolor = NOCOLOR ) { 
		return wb_draw_image(WBApplication::getInstance($this->buffer), WBApplication::getInstance($bitmap), $x, $y, $width, $height, $transparentcolor);
	}

	/**
	 * target line ׸ 
	 *
	 *
	 */
	public function line($x0, $y0, $x1, $y1, $color, $lineWidth = 1, $lineStyle = WBGraphics::LINE_SOLID) { 
		return wb_draw_line(WBApplication::getInstance($this->buffer), $x0, $y0, $x1, $y1, $color, $lineWidth, $lineStyle);
	}

	/**
	 *
	 * target rect(簢)  ׸ 
	 *
	 */
	public function rect($x, $y, $width, $height, $color , $filled = false, $lineWidth = 1, $lineStyle = WBGraphics::LINE_SOLID) { 
		return wb_draw_rect(WBApplication::getInstance($this->buffer), $x, $y, $width, $height, $color, $filled, $lineWidth, $lineStyle);
	}

	/**
	 *
	 * target ellipse(Ÿ)  ׸ 
	 *
	 */
	public function ellipse($x, $y, $width, $height, $color , $filled = false, $lineWidth = 1, $lineStyle = WBGraphics::LINE_SOLID) { 
		return wb_draw_ellipse(WBApplication::getInstance($this->buffer), $x, $y, $width, $height, $color, $filled, $lineWidth, $lineStyle);
	}

	/**
	 *   pixel color   
	 *
	 *
	 */
	public function getPixel($x, $y) { 
		return wb_get_pixel(WBApplication::getInstance($this->buffer), $x, $y);
	}

	/**
	 *   pixel color  ϱ 
	 *
	 *
	 */ 
	public function setPixel($x, $y, $color) { 
		return wb_draw_point(WBApplication::getInstance($this->buffer), $x, $y, $color);
	}

	/**
	 * text ׸ 
	 *
	 * <code>
	 * //flags  
	 *
	 * WBC_LEFT
	 * WBC_CENTER
	 * WBC_RIGHT
	 * WBC_TOP
	 * WBC_MIDDLE
	 * WBC_BOTTOM
	 * WBC_MULTILINE
	 * WBC_ELLIPSIS
	 * </code>
	 */ 
	public function text($text, $x, $y) { 
		$arr = func_get_args();

		if (sizeof($arr) == 4) { 
			return wb_draw_text(WBApplication::getInstance($this->buffer), $text, $x, $y);
		} elseif (sizeof($arr) == 5) { 
			return wb_draw_text(WBApplication::getInstance($this->buffer), $text, $x, $y, WBApplication::getInstance($arr[4]));
		} elseif (sizeof($arr) == 6) { 
			return wb_draw_text(WBApplication::getInstance($this->buffer), $text, $x, $y, $arr[4], $arr[5]);
		} elseif (sizeof($arr) == 7) { 
			return wb_draw_text(WBApplication::getInstance($this->buffer), $text, $x, $y, $arr[4], $arr[5], WBApplication::getInstance($arr[6]));
		} elseif (sizeof($arr) > 7) { 
			return wb_draw_text(WBApplication::getInstance($this->buffer), $text, $x, $y, $arr[4], $arr[5], WBApplication::getInstance($arr[6]), $arr[7]);
		}
	}
}
?>