<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */


/**
 * WBFrame
 *
 * @package php.ui.winbinder
 */
class WBFrame extends WBControl { 

	private $_rootPanel = null;

	public function __construct($options = array()) { 
		$options['class'] = Frame;

		parent::__construct($options);
	}

	protected function initCreate() { 
		if (isset($this->image)) { 
			$this->style |= WBC_IMAGE;
		}
	}

	// ü ʱȭ 
	protected function initComponent() { 

		parent::initComponent();	

		// RootPanel  
		$this->setRootPanel(new WBPanel());

		if (isset($this->image))	{ 
			if(is_string($this->image)) { 
				$this->image = realpath($this->image);
			} 
			
			$this->setImage($this->image);
			
		}

		// ؽƮ  
		if (isset($this->text))		$this->setText($this->text);

		// ̾ƿ  
		if (isset($this->layout))	$this->setLayout($this->layout);
	}

	/** 
	 * ̾ƿ  
	 *
	 */
	public function doLayout() { 
		if ($this->_rootPanel instanceof WBPanel) { 

			$arr = wb_get_size($this->getText());

			//  ũ  
			$bounds	= $this->getBounds();

			$this->_rootPanel->setBounds(
				$bounds['x'],
				$arr[1]+4,
				$bounds['width'] - $bounds['x']*2, 
				$bounds['height'] -  ($arr[1]+4*2)
			);
		}
	}

	/** 
	 * root panel  
	 *
	 */
	public function setRootPanel($panel) { 
		$this->_rootPanel = $panel; 
	}

	/** 
	 * root panel  
	 *
	 * @return WBPanel 
	 */
	public function getRootPanel() { 
		return $this->_rootPanel;
	}

	/** 
	 * component ߰ 
	 *
	 * @return WBComponent 
	 */
	public function add($component) { 
		if ($this->_rootPanel instanceof WBPanel) { 
			return $this->_rootPanel->add(WBApplication::createObject($component, $this));
		}

		return $component;
	}

	/** 
	 * root panel  ̾ƿ  
	 *
	 *
	 */
	public function setLayout($layout) { 
		if ($this->_rootPanel instanceof WBPanel) { 
			$this->_rootPanel->setLayout($layout);
		}
	}
}

?>