<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */

/**
 * WBEvent Ŭ 
 *
 * @package php.ui.winbinder
 */
class WBEvent extends PObject { 

	private $window;
	private $id;
	private $ctrl;
	private $param1;
	private $param2;
	private $param3;

	/**
	 *  
	 *
	 */
	public function __construct($window = null, $id = 0, $ctrl = 0, $param1 = 0, $param2 = 0, $param3 = 0) { 
		$this->window	= $window;
		$this->id		= $id;
		$this->ctrl		= $ctrl;
		$this->param1	= $param1;
		$this->param2	= $param2;
		$this->param3	= $param3;
	}

	/** 
	 * ̺Ʈ  window instance  
	 * 
	 * @return resource 
	 */
	public function getWindow() { 
		return $this->window;
	}

	/** 
	 * ̺Ʈ  control instance  
	 * 
	 * @return resource 
	 */
	public function getCtrl() { 
		return $this->ctrl;
	}

	/** 
	 * ̺Ʈ  param1  
	 * 
	 * @return int
	 */
	public function getParam1() { 
		return $this->param1;
	}

	/** 
	 * ̺Ʈ  param2  
	 * 
	 * @return int 
	 */
	public function getParam2() { 
		return $this->param2;
	}

	/** 
	 * ̺Ʈ  param3  
	 * 
	 * @return int
	 */
	public function getParam3() { 
		return $this->param3;
	}

	/** 
	 * ̺Ʈ  control id  
	 * 
	 * @return resource 
	 */
	public function getId() { 
		return $this->id;
	}

	/** 
	 * ̺Ʈ  WBComponent  
	 * 
	 * @return WBComponent 
	 */
	public function object() { 
		return WBApplication::getObject($this->getId());
	}

	/** 
	 * ̺Ʈ  window ü  
	 * 
	 * @return WBWindow 
	 */
	public function window() { 
		return WBApplication::getWindow($this->getWindow());
	}

	/**
	 * 콺 x ǥ 
	 *
	 * @return int 
	 */
	public function getX() { 
		return ($this->param2 & 0xFFFF);
	}

	/**
	 * 콺 y ǥ 
	 *
	 * @return int 
	 */
	public function getY() { 
		return ($this->param2 & 0xFFFF0000) >> 16;
	}

	/**
	 * width  
	 *
	 * @return int 
	 */
	public function getWidth() { 
		echo $this->param3;
		return ($this->param3 & 0xFFFF);
	}

	/**
	 * height  
	 *
	 * @return int 
	 */
	public function getHeight() { 
		return ($this->param3 & 0xFFFF0000) >> 16;
	}

	/**
	 * WBC_KEYDOWN ̺Ʈ Ȯϱ 
	 *
	 * @return bool 
	 */
	public function isKeyDown() { 
		return $this->param1 == WBC_KEYDOWN;
	}

	/**
	 * WBC_KEYUP ̺Ʈ Ȯϱ 
	 *
	 * @return bool 
	 */
	public function isKeyUp() { 
		return $this->param1 == WBC_KEYUP;
	}

	/**
	 * WBC_DBLCLICK ̺Ʈ Ȯϱ 
	 *
	 * @return bool 
	 */
	public function isDoubleClick() { 
		return ($this->param1 & WBC_DBLCLICK);
	}

	/**
	 * 콺 LBUTTON Ȯϱ 
	 *
	 * @return bool 
	 */
	public function isLeftButton() { 
		return ($this->param1 & WBC_LBUTTON);
	}

	/**
	 * 콺 RBUTTON Ȯϱ 
	 *
	 * @return bool 
	 */
	public function isRightButton() { 
		return ($this->param1 & WBC_RBUTTON);
	}

	/**
	 * 콺 MBUTTON Ȯϱ 
	 *
	 * @return bool 
	 */
	public function isMiddleButton() { 
		return ($this->param1 & WBC_MBUTTON);
	}

	/**
	 * CONTROL Ű Ȯ 
	 *
	 * @return bool 
	 */
	public function isControl() { 
		return ($this->param1 & WBC_CONTROL);
	}

	/**
	 * SHIFT Ű Ȯϱ 
	 *
	 * @return bool 
	 */
	public function isShift() { 
		return ($this->param1 & WBC_SHIFT);
	}

	/**
	 * ALT Ű Ȯϱ 
	 *
	 * @return bool 
	 */
	public function isAlt() { 
		return ($this->param1 & WBC_ALT);		
	}

	/**
	 * WBC_GETFOCUS ̺Ʈ Ȯϱ 
	 *
	 * @return bool 
	 */
	public function isFocus() { 
		return ($this->param1 == WBC_GETFOCUS);		
	}

	/**
	 * WBC_RESIZE ̺Ʈ Ȯϱ 
	 *
	 * @return bool 
	 */
	public function isResize() { 
		return ($this->param1 == WBC_RESIZE);
	}

	/**
	 * WBC_REDRAW ̺Ʈ Ȯϱ 
	 *
	 * @return bool 
	 */
	public function isRedraw() { 
		return ($this->param1 & WBC_REDRAW);
	}

	/**
	 * WBC_MOUSEDOWN ̺Ʈ Ȯϱ 
	 *
	 * @return bool 
	 */
	public function isMouseDown() { 
		return ($this->param1 & WBC_MOUSEDOWN);
	}

	/**
	 * WBC_MOUSEUP ̺Ʈ Ȯϱ 
	 *
	 * @return bool 
	 */
	public function isMouseUp() { 
		return ($this->param1 & WBC_MOUSEUP);
	}

	/**
	 * WBC_MOUSEMOVE ̺Ʈ Ȯϱ 
	 *
	 * @return bool 
	 */
	public function isMouseMove() { 
		return ($this->param1 == WBC_MOUSEMOVE);
	}

	/**
	 * WBC_HEADERSEL ̺Ʈ Ȯϱ 
	 *
	 * @return bool 
	 */
	public function isHeaderSelected() { 
		return ($this->param1 & WBC_HEADERSEL);
	}

	public function isMaximized() { 
		return (wb_get_size($this->window) == WBC_MAXIMIZED);
	}

	public function isMinimized() { 
		return (wb_get_size($this->window) == WBC_MINIMIZED);
	}

	public function isNormal() { 
		return (wb_get_size($this->window) == WBC_NORMAL);
	}

	public function getCharacter() { 
		return chr($this->getKeyCode());
	}

	public function getKeyCode() { 
		return $this->param2;
	}

	public function isIDClose() { 
		return ($this->id == IDCLOSE);
	}

	public function toString() { 

		$temp = "";

		if ($this->isIDClose()) $temp .= "isIDClose". PHP_EOL;
		if ($this->isHeaderSelected()) $temp .= "isHeaderSelected". PHP_EOL;
		if ($this->isMouseMove()) {
				//$temp .= "isMouseMove". PHP_EOL;
				//$temp .= sprintf("%s, %s", $this->getX(), $this->getY());
		}
		if ($this->isMouseUp()) $temp .= "isMouseUp". PHP_EOL;
		if ($this->isMouseDown()) $temp .= "isMouseDown". PHP_EOL;
		if ($this->isRedraw()) $temp .= "isRedraw". PHP_EOL;
		if ($this->isResize()) { 
				$temp .= "isResize". PHP_EOL;
				$temp .= sprintf("%s, %s", $this->getWidth(), $this->getHeight());
		}
		if ($this->isFocus()) $temp .= "isFocus". PHP_EOL;
		if ($this->isAlt()) $temp .= "isAlt". PHP_EOL;
		if ($this->isKeyDown()) $temp .= "isKeyDown". PHP_EOL;
		if ($this->isKeyUp()) $temp .= "isKeyUp". PHP_EOL;
		if ($this->isDoubleClick()) $temp .= "isDoubleClick". PHP_EOL;
		if ($this->isLeftButton()) $temp .= "isLeftButton". PHP_EOL;
		if ($this->isRightButton()) $temp .= "isRightButton". PHP_EOL;
		if ($this->isMiddleButton()) $temp .= "isMiddleButton". PHP_EOL;
		if ($this->isControl()) $temp .= "isControl". PHP_EOL;
		if ($this->isShift()) $temp .= "isShift". PHP_EOL;
		return $temp;
	}
}

?>