<?php

/**
 *
 *
 * @package php.ui.winbinder 
 *
 */


/**
 * System Dialog 
 *
 *
 *
 */
class WBDialog extends PObject { 

	/**
	 *  ޼ 
	 *
	 */
	const INFO			= WBC_INFO;

	/**
	 * Ȯ ޼ 
	 *
	 */
	const OK			= WBC_OK;

	/**
	 * Ȯ  ޼ 
	 *
	 *
	 */
	const OKCANCEL		= WBC_OKCANCEL;

	/**
	 *  ޼ 
	 *
	 */
	const QUESTION		= WBC_QUESTION;

	/**
	 * STOP ޼ 
	 *
	 */
	const STOP			= WBC_STOP;

	/**
	 *  ޼ 
	 *
	 */
	const WARNING		= WBC_WARNING;

	/**
	 * YES NO ư ִ ޼ 
	 *
	 */
	const YESNO			= WBC_YESNO;

	/**
	 * YES NO CANCEL ư ִ ޼ 
	 *
	 *
	 */
	const YESNOCANCE	= WBC_YESNOCANCE;

	/**
	 * ޼ ڽ 
	 *
	 * Cancel, No, Ignore, Abort : false 
	 * OK, Yes, Retry  : true 
	 * others : null 
	 * 
	 * @return bool 
	 */
	public static function message($parent, $message , $title = '', $style = WBDialog::INFO) { 
		return wb_message_box(WBApplication::getInstance($parent), $message, $title, $style);
	}

	/**
	 * (Warning) ޼ ڽ 
	 *
	 * @see WBDialog::message() 
	 */
	public static function warning($parent, $message, $title = '') { 
		return WBDialog::message($parent, $message,  $title, WBDialog::WARNING);
	}

	/**
	 * OK, CANCEL ޼ ڽ 
	 *
	 */
	public static function okcancel($parent,$message, $title = '') { 
		return WBDialog::message($parent, $message,  $title, WBDialog::OKCANCEL);
	}

	/**
	 * INFO ޼ ڽ 
	 *
	 */
	public static function info($parent,$message, $title = '') { 
		return WBDialog::message($parent, $message,  $title, WBDialog::INFO);
	}

	/**
	 * QUESTION ޼ ڽ 
	 * 
	 *
	 */
	public static function question($parent,$message, $title = '') { 
		return WBDialog::message($parent, $message,  $title, WBDialog::QUESTION);
	}

	/**
	 * STOP ޼ ڽ 
	 *
	 *
	 */
	public static function stop($parent,$message, $title = '') { 
		return WBDialog::message($parent, $message,  $title, WBDialog::STOP);
	}

	/**
	 * YES, NO ޼ ڽ 
	 *
	 *
	 */
	public static function yesno($parent,$message, $title = '') { 
		return WBDialog::message($parent, $message,  $title, WBDialog::YESNO);
	}

	/**
	 * YES, NO, CANCEL ޼ ڽ 
	 *
	 *
	 */
	public static function yesnocancel($parent,$message, $title = '') { 
		return WBDialog::message($parent, $message,  $title, WBDialog::YESNOCANCEL);
	}

	/**
	 * color picker 
	 *
	 * <code>
	 *	$color = sprintf("%06X", WBGdi::colorHex(WBDialog::color($eo->window(), ' ׽Ʈ', WBGdi::rgbHex(0xFF0000))));
	 * </code>
	 * 
	 * @return int  -1 ̸ , 0 ̸̻  ǥ 
	 */
	public static function color($parent = null, $title = '', $color = 0) { 
		return wb_sys_dlg_color(WBApplication::getInstance($parent), $title, $color);
	}

	/**
	 *  ã ̾α 
	 * 
	 * <code>
	 * $filter = array(
	 * 		array("PHP source code",    "*.php"),
	 *      array("Web page",           "*.htm"),
	 * 	    array("Text document",      "*.txt"),
	 *      array("All files",          "*.*")
	 * );
	 * </code>
	 *
	 * @return string õ  ü  
	 */
	public static function open($parent = null, $title = '', $filter = null, $path = '', $filename = '')  {
		return wb_sys_dlg_open(WBApplication::getInstance($parent), $title, $filter, $path, $filename);
	}

	/**
	 *  ã ̾α 
	 *
	 *
	 * @return string õ 丮  
	 */
	public static function path($parent = null, $title = '', $path = '') { 
		return wb_sys_dlg_path (WBApplication::getInstance($parent), $title, $path);
	}


	/**
	 *   ã ̾α 
	 * 
	 * <code>
	 * $filter = array(
	 * 		array("PHP source code",    "*.php"),
	 *      array("Web page",           "*.htm"),
	 * 	    array("Text document",      "*.txt"),
	 *      array("All files",          "*.*")
	 * );
	 * </code>
	 *
	 * @return string õ ü  
	 */
	public static function save($parent = null, $title = '', $filter = null, $path = '', $filename = '', $ext = '')  {
		return wb_sys_dlg_save(WBApplication::getInstance($parent), $title, $filter, $path, $filename, $ext);
	}
}

?>