<?php
/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */

/**
 * WBComponent
 *
 * @package php.ui.winbinder
 */
class WBComponent extends WBObject { 

	private $_defaultEvent = array();

	private $_userEvent = array();

	protected $_isCreated = false;

	private $_options = array();

	private $_instance = null;

	private $_hwnd = null;

	/**
	 * WBComponent  
	 *
	 *  id Ӽ Ǿ   id ڵ ؼ Ѵ. 
	 *
	 * @param array $options WBComponent  ɼ Ʈ 
	 */
	public function __construct($options = array()) { 

		parent::__construct($options);

		// ü Ǳ  Ǵ Լ 
		$this->initCreate();

		// ü  
		$this->create();

		// ü    Ǵ Լ 
		$this->initComponent();
	}

	/**
	 * ü Ǳ  ȯ  
	 *
	 *
	 */
	protected function initCreate() { 

	}

	/**
	 * ⺻ ̺Ʈ  
	 */
	protected function initEvent() { 

		parent::initEvent();

		$this->setEvent('create', 'onCreate');
		$this->setEvent('resize', 'onResize');
		$this->setEvent('redraw', 'onRedraw');	

	}

	/**
	 * WBComponent ⺻  
	 *
	 * ⺻ ̺Ʈ  
	 */
	protected function initComponent() { 


	} 

	/** 
	 * instance  
	 *
	 * @return int WBComponent instance 
	 */
	public function getInstance() { 
		return $this->_instance;
	}

	/** 
	 * instance ϱ 
	 *
	 * @param int $instance 
	 */
	public function setInstance($instance) { 
		$this->_instance = $instance;
	}


	/**
	 * ü  
	 *
	 * create ̺Ʈ  
	 */
	public function create() { 

		// ü  
		if($this->instance) { 
			$this->setInstance($this->instance);
		} else { 
			if (!$this->_isCreated) { 
				// ü   Ǵ ̺Ʈ 
				//$this->fireEvent('create');

				$this->setInstance($this->createComponent());

				$this->_isCreated = true;
			}
		}
	}

	/**
	 * ü    , instance  
	 *
	 * @return int WBComponent instance 
	 */
	protected function createComponent() { 
		return null;	
	}

	/**
	 * ּһ  
	 *
	 */
	public function setMinimumSize($width = 0, $height = 0){
		$this->minimumWidth = $width;
		$this->minimumHeight = $height;
	}

	/** 
	 * ּ   
	 *
	 */
	public function getMinimumSize() { 
		return array(
			'width'		=> ($this->minimumWidth)	? $this->minimumWidth	: 0, 
			'height'	=> ($this->minimumHeight)	? $this->minimumHeight	: 0,
		);
	}

	/**
	 * ִ   
	 *
	 */
	public function setMaximumSize($width = 0, $height = 0) {
		$this->maximumWidth = $width;
		$this->maximumHeight = $height;
	}

	/**
	 * ִ   
	 *
	 */
	public function getMaximumSize() { 
		return array(
			'width'		=> ($this->maximumWidth)	? $this->maximumWidth	: 0, 
			'height'	=> ($this->maximumHeight)	? $this->maximumHeight	: 0,
		);
	}

	/**
	 * ̾ƿ  
	 *
	 */
	public function doLayout() { 

	}

	/**
	 * ٽ ׸  
	 *
	 */ 
	public function repaint($graphics) { 
		
	}

	/**
	 *   ٽ ׸ 
	 *
	 * @param bool $now  true :  , false : ߿(?)
	 */
	public function refresh($now = false) { 
		$arg = func_get_args();

		if (sizeof($arg) == 1) { 
			return wb_refresh($this->getInstance(), $now);
		} else { 
			return wb_refresh($this->getInstance(), $now, $arg[1], $arg[2], $arg[3], $arg[4]);
		}
	}

	/**
	 * Ŭ   
	 *
	 * @return int Ŭ  
	 */
	public function getClass() { 
		return wb_get_class($this->getInstance());
	}

	/**
	 * focus  
	 * 
	 * @return int focus   ִ instance 
	 */ 
	public function getFocus() { 
		return wb_get_focus();
	}

	
	/**
	 *  WBComponent focus  
	 *
	 * @return bool 
	 */
	public function setFocus() { 
		return wb_set_focus($this->getInstance());
	}

	/**
	 *  WBComponent id   
	 *
	 * @param int 
	 */
	public function getId() { 
		return wb_get_id($this->getInstance());
	}

	/**
	 *  WBComponent instance  
	 *
	 * @param int $item TreeView item 
	 * @return int instance 
     *
	 */ 
	public function getParent($item = null) { 
		return wb_get_parent($this->getInstance(), $item);
	}

	/**
	 *  WBComponent Child Component   
	 *
	 * @return int 
	 */
	public function getItemCount() { 
		return wb_get_item_count($this->getInstance());
	}

	/**
	 *  WBComponent Child Component  instance Ʈ 
	 *
	 * @return array 
	 */
	public function getItemList() { 
		return wb_get_item_list($this->getInstance());
	}

	/**
	 *  ġ   
	 *
	 * @param bool $clientarea true̸  , false ̸ ü  
	 * @return array  ġ 
	 */
	public function getPosition($clientarea = false) { 
		$arr = wb_get_position($this->getInstance(), $clientarea);

		return array('x' => $arr[0], 'y' => $arr[1]);
	}

	/**
	 *  ġ  
	 *
	 * @param int $x xǥ 
	 * @param int $y yǥ 
	 * @return bool 
	 */
	public function setPosition($x = WBC_CENTER, $y = WBC_CENTER) { 
		return wb_set_position($this->getInstance(), $x, $y);
	}

	/**
	 *  Ǵ Ʈ ũ  
	 *
	 * @param bool $lparam true ̸  ǥÿ
	 * @return array 
	 */
	public function getSize($lparam = false) { 
		$arr = wb_get_size($this->getInstance(), $lparam);

		if (is_array($arr)) { 
			return array('width' => $arr[0], 'height' => $arr[1]);
		} else { 
			return $arr;
		}
	}

	/**
	 * ⺻ũ  
	 *
	 * @return array 
	 */
	public function getPreferedSize() { 
		return $this->getSize();
	}

	/**
	 *  Ǵ Ʈ ũ ϱ 
	 *
	 * @param int $width 
	 * @param int $height 
	 */
	public function setSize($width, $height = null) { 
		$bool = false;

		if (is_null($height)) { 
			$bool = wb_set_size($this->getInstance(), $width);			
		} else { 
			$bool = wb_set_size($this->getInstance(), $width, $height);
		}

		$this->fireEvent('resize');

		return $bool;
	}

	/**
	 * text, caption  
	 *
	 * @param int $item 
	 * @param int $subitem
	 * @return string 
	 */
	public function getText($item = null, $subitem = null) { 
		return wb_get_text($this->getInstance(), $item, $subitem);
	}

	/**
	 * text,caption ϱ 
	 *
	 * @param string $text  ؽƮ 
	 * @param int $item 
	 * @param int $subitem 
	 *
	 */
	public function setText($text, $item = null, $subitem = null) { 
		return wb_set_text($this->getInstance(), $text, $item, $subitem);
	}

	/**
	 * ̱  
	 *
	 * @return bool 
	 */
	public function isVisible() { 
		return wb_get_visible($this->getInstance());
	}

	/**
	 * ̱   
	 *
	 * @param bool $isVisible 
	 */
	public function setVisible($isVisible = true) { 
		wb_set_visible($this->getInstance(), $isVisible);
	}

	/**
	 * ̹ ϱ 
	 *
	 * @param int $source 
	 * @param int $transparentcolor
	 * @param int $index 
	 * @param int $param 
	 */
	public function setImage($source, $transparentcolor = NOCOLOR, $index = 1, $param = 0) { 

		if (is_string($source)) { 
			$source = WBImage::loadFile($source);
		} 

		return wb_set_image($this->getInstance(), WBApplication::getInstance($source), $transparentcolor, $index, $param);
	}

	/**
	 * Ȱ  ϱ 
	 *
	 */
	public function setArea($type, $x = 0, $y = 0, $width = 0, $height = 0){
		return wb_set_area($this->getInstance(), $type, $x, $y, $width, $height);
	}

	/**
	 * style ϱ 
	 *
	 * @param int $style  style 
	 * @param bool $set 
	 */
	public function setStyle($style, $set = true ) { 
		return wb_set_style($this->getInstance(), $style, $set);
	}

	/**
	 * ġ, ũ   
	 *
	 * @param int $x 
	 * @param int $y 
	 * @param int $width 
	 * @param int $height 
	 */
	public function setBounds($x, $y, $width, $height) { 
		$this->setPosition($x, $y);
		$this->setSize($width, $height);
	}

	/**
	 * Ʈ  
	 *
	 * @param mixed $font 
	 * @param bool $redraw 
	 */
	public function setFont($font, $redraw = false	) { 
		return wb_set_font($this->getInstance(), WBApplication::getInstance($font), $redraw);
	}

	/**
	 * ġ,   
	 * 
	 */
	public function getBounds($lparam = false) { 
		$size = $this->getSize($lparam);
		$pos = $this->getPosition($lparam);

		return $size + $pos;
	}


	/**
	 * ü ڿ  
	 *
	 * @return string 
	 */
	public function toString() { 
		$temp = get_class($this).PHP_EOL;

		return $temp;
	}

	/**
	 * WBC_REDRAW ̺Ʈ  
	 *
	 * repaint() ޼ҵ Graphics ü Ѱش. 
	 */
	public function onRedraw($eo) { 
		//  ü ٽ ׸. 
		$this->repaint($this->getGraphics());

	}

	/**
	 * WBC_RESIZE ̺Ʈ  
	 *
	 * doLayout() ޼ҵ带  
	 */
	public function onResize() { 
		// ̾ƿ ٽ ׸ 
		$this->doLayout();
	}

	/**
	 * WBGraphics ü  
	 *
	 * @return WBGraphics 
	 */
	public function getGraphics() { 
		return new WBGraphics($this->getHwnd()->buffer);
	}

	/**
	 * WinBinder ο ϴ ü ش. 
	 *
	 * 
	 * @see WBStruct
	 * @see WBOBJ 
	 */
	public function getHwnd() { 

		if (!$this->_hwnd) { 
			$this->_hwnd = new WBOBJ($this);
		}

		return $this->_hwnd;
	}

	/**
	 * id شϴ Ʈ instance ´. 
	 *
	 * @return resource 
	 */
	public function getControl($id) { 
		return wb_get_control($this->getInstance(), $id);
	}

	/**
	 * Control  ޼ . 
	 *
	 */
	public function send($message, $wparam, $lparam) { 
		return WBLibrary::send(WBApplication::getInstance(WBApplication::getParent($this)), $message, $wparam, $lparam);
	}
}

?>