<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */


/**
 * ComboBox
 *
 * @package php.ui.winbinder
 */
class WBComboBox extends WBControl { 
	public function __construct($options = array()) { 
		$options['class'] = ComboBox;

		parent::__construct($options);
	}

	protected function initCreate() { 
		parent::initCreate();

		if (isset($this->readOnly))	$this->style |= WBC_READONLY;
	}

	// ü ʱȭ 
	protected function initComponent() { 
		parent::initComponent();	

		if (isset($this->items))	$this->setItems($this->items);
		if (isset($this->sort))		$this->sort($this->sort);
	}

	/**
	 *  Ʈ  
	 *
	 * @param array|string $items  Ʈ 
	 */
	public function setItems($items) { 

		if (is_array($items)) { 
			$arr = $items;
		} else if (is_string($items)) { 
			$arr = array_map('trim', explode("\n", $items));
		}

		
		$this->setText($arr);
		$this->items = $arr;
	}

	/**
	 *  Ʈ  
	 *
	 * @return array 
	 */
	public function getItems() { 
		return $this->items;
	}

	/**
	 *  ߰ ϱ 
	 * 
	 * @param string $text  ߰ϱ 
	 *
	 */
	public function addItem($text) { 
		$this->items[] = $text;
		$this->setText($this->items);
	}

	/**
	 *   ϱ 
	 *
	 * @param int|string $data   ε Ǵ ؽƮ 
	 */
	public function deleteItem($data) { 
		if (is_int($data)) { 
			unset($this->items[$data]);

			$temp = array_merge(array(), $this->items);

			$this->setItems($temp);
		} else if (is_string($data)) { 
			$this->deleteItems(array_search($data, $this->items));
		}
	}

	/**
	 *  õǾ index  
	 *
	 * @return int 
	 */
	public function getSelectedIndex() { 
		return $this->getSelected();
	}

	/**
	 * õǾ index text  
	 *
	 * @param int|string $index  $index    õǾ index,  ƴϸ  $index 
	 * @return string text 
	 */
	public function getValue($index = '') { 
		if ($index === '') { 
			return parent::getValue($this->getSelectedIndex());
		} 

		return parent::getValue($index);
	}

	/**
	 * Ʈ ϱ 
	 *
	 * @param int $index õǾ index, -1 õǾ Ʈ  
	 */
	public function setSelectedIndex($index = -1) { 
		$this->setValue($index);
	}


	/**
	 *   
	 *
	 * @param bool $asc true : , false :  , ڿ   
	 */
	public function sort($asc = true, $sort_flag = 'string') { 

		if (is_string($sort_flag)) { 
			$sort_flag = constant("SORT_".strtoupper($sort_flag));
		}

		$items = $this->getItems();

		($asc) ? sort($items, $sort_flag) : rsort($items, $sort_flag) ;

		$this->setItems($items);
	}

}

?>