<?php
/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */

/**
 * CheckBox 
 * 
 * @package php.ui.winbinder
 */
class WBCheckBox extends WBControl { 
	public function __construct($options = array()) { 
		$options['class'] = CheckBox;

		parent::__construct($options);
	}

	// ü ʱȭ 
	protected function initComponent() { 
		parent::initComponent();

		// üũ ǥ 
		if (isset($this->checked))  $this->setChecked($this->checked);

		// ToolTip ǥ 
		if (isset($this->tooltip)) $this->setToolTip($this->tooltip);		
	}

	/**
	 * üũ¿ 
	 *
	 * @return bool true : üũ, false : üũ  
	 */
	public function isChecked() { 
		return $this->getValue();
	}

	/**
	 * üũ  
	 *
	 * @param bool $isChecked true : üũ, false : üũ  
	 */
	public function setChecked($isChecked = true) { 
		$this->setValue($isChecked);
	}

	public function setToolTip($tooltip) { 
		$this->setText(array(null, $tooltip));
	}

	/**
	 * ⺻ũ  
	 * 
	 */
	public function getPreferedSize() { 
		$arr = wb_get_size($this->getText());

		return array(
			'width' => $arr[0] + 20,
			'height' => $arr[1] + 10,
		);
	}
}

?>