<?php
/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */


import("php.ui.winbinder.default.winbinder");

/**
 * Application Ŭ 
 *
 * @package php.ui.winbinder
 */
class WBApplication { 

	/**
	 * ̵ ⺻  
	 *
	 */
	public static $_idCount = 10000;

	/**
	 * ̵ Control Ʈ 
	 *
	 */
	public static $_idList = array();

	/**
	 * ̸ id Ʈ 
	 *
	 */
	public static $_nameList = array();

	/**
	 * instance window Ʈ 
	 *
	 */
	public static $_windowList = array();

	/**
	 * ̺Ʈ  ڿ Ʈ 
	 *
	 */
	public static $_eventList = array(
		WBC_DBLCLICK	=> 'dblclick',
		WBC_MOUSEMOVE	=> 'mousemove',
		WBC_MOUSEDOWN	=> 'mousedown',
		WBC_MOUSEUP		=> 'mouseup',
		WBC_KEYDOWN		=> 'keydown',
		WBC_KEYUP		=> 'keyup',
		WBC_GETFOCUS	=> 'focus',
		WBC_REDRAW		=> 'redraw',
		WBC_RESIZE		=> 'resize',
	);

	/**
	 * Ŭ ڿ 
	 *
	 */
	public static $_classList = array(
		AppWindow		=> 'AppWindow',
		ModalDialog		=> 'ModalDialog',
		ModelessDialog	=> 'ModelessDialog',
		NakedWindow		=> 'NakedWindow',
		PopupWindow		=> 'PopupWindow',
		ResizableWindow	=> 'ResizableWindow',
		ToolDialog		=> 'ToolDialog',

		Accel			=> 'Accel',
		Calendar		=> 'Calendar',
		CheckBox		=> 'CheckBox ',
		ComboBox		=> 'ComboBox',
		EditBox			=> 'EditBox',
		Frame			=> 'Frame',
		Gauge			=> 'Gauge',
		HTMLControl		=> 'HTMLControl',
		HyperLink		=> 'HyperLink',
		ImageButton		=> 'ImageButton',
		Label			=> 'Label',
		ListBox			=> 'ListBox',
		ListView		=> 'ListView',
		Menu			=> 'Menu',
		PushButton		=> 'PushButton',
		RadioButton		=> 'RadioButton',
		RTFEditBox		=> 'RTFEditBox',
		ScrollBar		=> 'ScrollBar',
		Slider			=> 'Slider',
		Spinner			=> 'Spinner',
		StatusBar		=> 'StatusBar',
		TabControl		=> 'TabControl',
		ToolBar			=> 'ToolBar',
		TreeView		=> 'TreeView',


	);

	/**
	 * ̺Ʈ   
	 *
	 *
	 */
	public static function start() { 
		wb_main_loop();
	}

	/**
	 * id Ǵ name  Control ü  
     * 
	 * @param int|string $id Control ̵ 
	 * @return WBComponent 
	 */
	public static function getObject($id) { 
		if (is_string($id)) { 
			$id = self::$_nameList[$id];
		}

		return self::$_idList[$id];
	}

	/**
	 * id ü  
	 *
	 * @param int $id Ʈ ̵ 
	 * @param WBComponent $obj Ʈ ü 
	 */
	public static function setObject($id, $obj) { 
		if(isset(self::$_idList[$id])) { 
			return false;
		} else { 
			self::$_idList[$id] = $obj;
			return true;
		}
	}

	/**
	 * name id  
	 *
	 * @param string $name Ʈ ü ̸ 
	 * @param int $id Ʈ ̵ 
	 */
	public static function setName($name, $id) { 
		if(isset(self::$_nameList[$name])) { 
			return false;
		} else { 
			self::$_nameList[$name] = $id;
			return true;
		}
	}

	/**
	 * instance ´ window ü  
	 *
	 * @param int $instance windowü instance 
	 * @return WBWindow 
	 */
	public static function getWindow($instance) { 
		return self::$_windowList[$instance];
	}

	/**
	 * instance  window ü  
	 * 
	 * @param int $instance 
	 * @param WBWindow $obj 
	 */
	public static function setWindow($instance, $obj) { 
		if(isset(self::$_windowList[$instance])) { 
			return false;
		} else { 
			self::$_windowList[$instance] = $obj;
			return true;
		}
	}

	/**
	 * ü ֻ  ü  
	 *
	 * @param WBComponent $obj   ü  component
	 * @return mixed WBWindow, WBTabControl, null  
	 */
	public function getParent($obj) { 

		if(is_null($obj)) return null;
		if ($obj instanceof WBWindow) return $obj;
		if ($obj instanceof WBTabControl) return $obj;
		if ($obj instanceof WBComponent) return WBApplication::getParent($obj->parent);
	}

	/**
	 * unique id  
	 *
	 * @return int 
	 */
	public static function getIdCount() { 
		++self::$_idCount;

		return self::$_idCount;
	}

	/**
	 * ̺Ʈ  
	 *
	 * @param int $key ̺Ʈ  
	 * @return string 
	 */
	public static function event($key) { 
		return self::$_eventList[$key];
	}

	/**
	 * instance  
	 *
	 * @param mixed $obj instance  ִ ü 
	 * @return mixed getInstance() ޼ҵ带   getInstance(),  $obj ״ 
	 */
	public static function getInstance($obj) { 
		return (method_exists($obj, 'getInstance')) ? $obj->getInstance(): $obj;
	}

	/**
	 * wbtype  ü ϱ 
	 *
	 *
	 * @param array|WBComponent $options 
	 * @return WBComponent 
	 */
	public static function createObject($options, $parent = null) { 
		if (is_array($options)) { 

			// wbtype  ʾ  Panel νѴ. 
			$options['wbtype'] = isset($options['wbtype']) ? $options['wbtype'] : 'Panel';

			if ($options['wbtype']) { 
				$class = strtolower("wb{$options['wbtype']}");

				if (!isset($options['parent'])) { 
					$options['parent'] = WBApplication::getParent($parent);
				}

				$component = new $class($options);

				return $component;
			}
		}

		return $options;
	}

	/**
	 * Ŭ   ڿ 
	 *
	 * @param string $class Ŭ  
	 * @return string 
	 * 
	 */
	public static function getClassName($class) { 
		return self::$_classList[$class];
	}
}

?>