<?php 
/*
$sql = "
SELECT
		B.TABLE_NAME			AS TABLE_NAME,
		B.CONSTRAINT_NAME		AS INDEX_NAME,
		B.ORDINAL_POSITION		AS COLUMN_POSITION,	
		B.COLUMN_NAME			AS COLUMN_NAME,
		''						AS DESCEND,
		''						AS UQ,
		(
			select case when count(*) > 1 then 'PK' else '' end  as f 
			from INFORMATION_SCHEMA.TABLE_CONSTRAINTS
			where CONSTRAINT_NAME = B.CONSTRAINT_NAME AND CONSTRAINT_TYPE = 'PRIMARY KEY'
		)	as PK
FROM 
	 INFORMATION_SCHEMA.KEY_COLUMN_USAGE B
where 
	B.TABLE_SCHEMA = '{$meta_info['schema_name']}' and B.TABLE_NAME = '{$meta_info['object_name']}'
order by 
	B.ORDINAL_POSITION
";
*/

$sql = " show index from {$meta_info['object_name']} ";

$_data = $this->getData($sql);

//echo $_data;


$_temp_data = new DBData($this);
$_temp_data->setFields(
		array(
			'TABLE_NAME',
			'INDEX_NAME',
			'COLUMN_POSITION',	
			'COLUMN_NAME',
			'DESCEND',
			'UQ',
			'PK',
			'INDEX_TYPE',
			'ISNULL',
			'COMMENT'
		)
);

while($_data->next()) { 
	$_temp_data->add(
		array(
			'TABLE_NAME'		=> $_data->table,
			'INDEX_NAME'		=> $_data->key_name,
			'COLUMN_POSITION'	=> $_data->seq_in_index,	
			'COLUMN_NAME'		=> $_data->column_name,
			'DESCEND'			=> ($_data->collation == 'A') ? 'ASC' : 'DESC',
			'UQ'				=> ($_data->non_unique == 1) ? '' : 'UQ',
			'PK'				=> ($_data->key_name == 'PRIMARY') ? 'PK' : '',
			'INDEX_TYPE'		=> $_data->index_type,
			'ISNULL'			=> ($_data->null == 'YES') ? 'Y' : 'N',
			'COMMENT'			=> $_data->comment
		)	
	);

}

$_data = null;

return $_temp_data;

?>