<?php

$sql = "
select 	
	distinct  A.CLASS_NAME		AS TABLE_NAME, 
	A.DOMAIN_CLASS_NAME AS DOMAIN_NAME,
	A.DEF_ORDER			AS ORDINAL_POSITION,
	A.ATTR_NAME			AS COLUMN_NAME,
	''					AS COLUMN_COMMENT, 
	
	case 
		when A.DATA_TYPE = 'STRING' and A.PREC < 107374182 then  'VARCHAR'
		else A.DATA_TYPE
	end AS DATA_TYPE, 	
	case 
	   when A.data_type IN ('CHAR', 'VARNCHAR', 'NCHAR', 'STRING') then to_char(A.PREC)
	   ELSE ''
	end					AS DATA_LENGTH, 
	A.PREC				AS DATA_PREC,
	A.SCALE				AS DATA_SCALE,
    case 
        when A.IS_NULLABLE = 'YES' then 'NULL'
        else ''
    end					AS ISNULL, 

	case
		when A.data_type = 'OBJECT'  then A.DOMAIN_CLASS_NAME	
	end 				AS OPTIONS, 
	'N'					AS ISAUTO,
	case
		when A.data_type IN ('SET', 'SEQUENCE', 'MULTISET')  then 
				set (
						select 	
								case when data_type = 'OBJECT' then domain_class_name 
									when data_type = 'CHAR' or data_type = 'NCHAR' then data_type || '('  || prec || ')'
									else data_type 
								end  
						from db_attr_setdomain_elm 
						where class_name = A.class_name and attr_name = a.attr_name
				) 
	end 				AS OPTIONS2, 
	A.DEFAULT_VALUE		AS COLUMN_DEFAULT,
	CASE 
		WHEN B.IS_PRIMARY_KEY = 'YES' THEN 'PK' 
		ELSE '' 
	END 				AS PK,
	CASE 
		WHEN B.IS_UNIQUE = 'YES' THEN 'UQ' 
		ELSE '' 
	END 				AS UQ,
	''					AS C 
from 
    DB_ATTRIBUTE A  
	LEFT OUTER JOIN DB_INDEX_KEY C ON (A.CLASS_NAME = C.CLASS_NAME AND A.ATTR_NAME = C.KEY_ATTR_NAME)
	LEFT OUTER JOIN DB_INDEX B ON (C.INDEX_NAME = B.INDEX_NAME)

where  
	A.CLASS_NAME = '{$meta_info['object_name']}'
order by 
	A.DEF_ORDER

";

return $this->getData($sql);

?>