<?php
/**
 * Sqlite
 *
 * @package php.db
 */

//import("php.db.DBClient");

/**
 * sqlite  Ŭ 
 *
 * @package php.db
 */
class Sqlite extends DBClient {

	/**
	 * 
	 *
	 */
	public function __construct($option) {
		parent::__construct($option);
	}

	/**
	 * database  
	 * 
	 * @return resource  resource
	 */
	protected function _connect() { 
		return sqlite_open($this->host.$this->db);
	}

	/**
	 *  row  
	 *
	 * @return int 
	 */
	public function affectedRows() { 
		return sqlite_changes($this->getConnection());
	}

	/**
	 *  ݱ 
	 */
	public function close()
	{
		if ($this->getConnection()) { 
			sqlite_close($this->getConnection());
		}
	}

	/**
	 *  ޼ 
	 * 
	 * @return string  ޼ 
	 */	
	public function error() {
		return sqlite_error_string(sqlite_last_error($this->getConnection())) ;
	}

	/**
	 * ڿ escape	
	 * 
	 * @param string $str  escape  ڿ 
	 * @return string escape  ڿ
	 */
	public function escape($str) { 
		return sqlite_escape_string ($str);
	}


	/**
	 *  select  ؼ fetch    (row) Ѵ. 
	 *
	 * ϵǴ  array('ʵ' => '', ...); ¸ . 
	 * 
	 * @param resource $result select   resource
	 * @return array row Ÿ 
	 */
	public function fetch($result, $result_type = SQLITE_ASSOC) {
		return sqlite_fetch_array($result, $result_type);
	}

	public function fetchAll($result, $result_type = SQLITE_ASSOC, $decode_binary = true) { 
		return sqlite_fetch_all($result, $result_type, $decode_binary);
	}

	/** 
	 * ޸  
	 * 
	 * @return bool
	 */
	public function free($result) {
		return true;
	}

	/**
	 *    ʵ  Ѵ.
	 *
	 * @param resource $result select   resource
	 * @return int ʵ尳 
	 */
	public function getFieldCount($result) {
		return sqlite_num_fields($result);
	}

	/**
	 *  ġ ʵ ̸ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵ̸ 
	 */
	public function getFieldName($result, $i) {
		return sqlite_field_name($result, $i);
	}

	/**
	 *  ġ ʵ Ÿ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵŸ
	 */
	public function getFieldType($result, $i) {
		return "varchar";
	}


	/**
	 * select  ؼ ¡ DBData Ѵ. 
	 *
	 * @param string $query select 
	 * @param int $page    
	 * @param int $count  Ʈ  
	 * @return DBData
	 */
	function getPageData($query, $page, $count = 10)
	{
		//  ϱ 
		$start = ($page-1)*$count;

		$query .= " limit $start, $count";

		return $this->getData($query, false);
	}

	/** 
	 * Ϲ   
	 * 
	 * @param string $sql  query 
	 * @return resource  resource
	 */
	public function query($sql) {
		$this->setResult(sqlite_query($this->getConnection(), $sql));
		return $this->getResult();
	}

	/**
	 * Ŀ ̵ 
	 * 
	 * @param int $count ̵ų ġ,  0 
	 * @return bool
	 */
	public function seek($count) { 
		return sqlite_seek ( $this->getResult(), $count );
	}

	public function spExecute() { 

	}
}

?>