<?php
/**
 * Sql
 *
 * @package php.db
 */
import("php.lang.PObject");

/**
 * SQL  ִ Ŭ 
 *
 * @package php.db
 */
class Sql extends PObject {
	private $type;
	private $table;
	private $data = array();
	private $field = array();
	private $where = array();
	private $from = '';
	private $top = '';

	private $ddl;

	public function __construct($type = 'mysql', $ddl = "")
	{
		$this->type = $type;
		$this->data = array();
		$this->field = array();
		$this->where = array();
		$this->from = '';

		$this->ddl = $ddl;
	}

	// Ÿ ߰
	public function add($field, $value = '', $isQuote = true)
	{
		$this->field[] = $field;
		$this->data[$field] = array($this->escape($value), $isQuote);
	}

	// where ߰
	public function addWhere($re, $field, $op, $value, $isQuote = true)
	{
		if ($isQuote) {
			$this->where[] = "$re $field $op ".$this->escape($value)."";
		} else  {
			$this->where[] = "$re $field $op ".$this->escape($value)."";
		}
	}

	// data ü ,  ڿ 
	private function getData()
	{
		if ($this->ddl == "insert") {
			$temp = array();
			
			foreach($this->data as $arr) {
				if ($arr[1]) {
					$temp[] = "'".$arr[0]."'";
				} else {
					$temp[] = $arr[0];
				}
			}

			return implode(",", $temp);
			
		} else if ($this->ddl == "update") {
			$temp = array();
			
			foreach($this->data as $field => $arr) {
				if ($arr[1]) {
					$temp[] = " ".$this->escapeField($field)." = '".$arr[0]."'";
				} else {
					$temp[] = " ".$this->escapeField($field)." = ".$arr[0]."";
				}
			}

			return implode(",", $temp);
		} else {
			return implode(", ", $this->data);
		}

	}

	// field ü ,  ڿ 
	private function getField($type = "") {
		$arr = $this->field;

		foreach ($arr as $key => $value) {
//			$arr[$key] = $this->escapeField($value); 
			$arr[$key] = $value; 
		}

		if ($type == "select") {
			if ($this->hasField()) {

			} else {
				return " * "; 
			}
		} 

		return implode(",", $arr);
	}

	// where ü   ڿ 
	private function getWhere()
	{
		if ($this->hasWhere()) {
			return " WHERE ".implode(" ", $this->where)." ";
		} else {
			return " ";
		}
	}

	// data  ִ 
	private function hasData()
	{
		return (count($this->data)>0);
	}

	// field  ִ 
	private function hasField()
	{
		return (count($this->field)>0);
	}

	// where  ִ 
	private function hasWhere()
	{
		return (count($this->where)>0);
	}

	public function setFrom($from) {
		$this->from = $from;
	}

	private function hasFrom() {
		return !empty($this->from);
	}

	private function getFrom() {
		return $this->from;
	}

	private function hasTop() {
		return !empty($this->top);
	}

	public function setTop($top) {
		$this->top = $top;
	}

	private function getTop() {
		return $this->top;
	}

	public 	function getDelete()
	{
		$str = "DELETE ";
		
		
		if ($this->hasFrom())  {
			$str .= " FROM ".$this->getFrom()." ";
		}

		$str .= $this->getWhere() ;

		return $str;
	}

	public 	function getUpdate()
	{
		$str = "UPDATE ".$this->getFrom()." ";
		$str .= "SET ".$this->getData();
		$str .= $this->getWhere() ;

		return $str;
	}

	public 	function getInsert()
	{
		$str = "INSERT INTO ".$this->getFrom();

		if ($this->hasField()) {
			$str .= " (".$this->getField().") ";
		}

		$str .= " VALUES (".$this->getData().")";

		return $str;
	}

	//  select
	public function getSelect()
	{
		$str = "SELECT ";

		if ($this->type == 'mssql' && $this->hasTop()) {
			$str .= " top ".$this->getTop();
		}

		if ($this->hasField()) {
			$str .= " ".$this->getField()." ";
		} else {
			$str .= " * ";
		}

		if ($this->hasFrom())  {
			$str .= " FROM ".$this->getFrom()." ";
		}

		$str .= $this->getWhere() ;

		return $str;
	}

	// īƮ select : cnt  
	public function getCountSelect()
	{
		$str = "SELECT count(*) as cnt ";

		if ($this->hasFrom())  {
			$str .= " FROM ".$this->getFrom()." ";
		}

		$str .= $this->getWhere() ;

		return $str;
	}

	public function escape($str) {
		return str_replace("'", "''", $str);
	}

	public function escapeField($field) {
		switch (strtolower($this->type)) {
			case "oracle":
				return "{$field}";
			case "mssql":
				return "[{$field}]";;
			case "mysql":
				return "`{$field}`";;
		}
	}

	public 	function toString() 
	{
		switch($this->ddl) {
			case "update" : return $this->getUpdate(); break;
			case "insert" : return $this->getInsert(); break;
			case "delete" : return $this->getDelete(); break;
			case "select" : return $this->getSelect(); break;
			default : return ""; break;
		}
	}
}


?>