<?php
/**
 * Mssql
 *
 * @package php.db
 */

/**
 * Mssql  Ŭ 
 * 
 * @package php.db
 */
class Mssql extends DBClient {

	/** 
	 * 
	 */
	public function __construct($option) {
		parent::__construct($option);
	}


	/**
	 * database  
	 * 
	 * @return resource  resource
	 */
	protected function _connect() { 
		$connection = mssql_connect(sprintf("%s,%s", $this->host, $this->port), $this->id, $this->pass, $this->newlink);

		$selected	= mssql_select_db($this->db, $connection);

		return ($connection && $selected) ? $connection : false;

	}

	/** 
	 * DB ϱ 
	 */
	public function selectDB($db_name) { 
		return mssql_select_db($db_name, $this->getConnection());
	}

	/**
	 *  row  
	 *
	 * @return int 
	 */
	public function affectedRows() { 
		return mssql_rows_affected($this->getConnection());
	}

	/**
	 *  ġ ڵ   
	 *
	 * @param resource $result select  resource
	 * @return bool
	 * @see Mssql::query()
	 */
	public function batch($result) { 
		return mssql_fetch_batch($result);
	}

	/**
	 * Ʈ  
	 * 
	 * @return bool 
	 * @see Mssql::commit(), Mssql::rollback();
	 */
	public function begin() { 
		return $this->query("BEGIN TRAN");
	}

	/**
	 *  ݱ 
	 */
	public function close() {
		if ($this->getConnection()) { 
			mssql_close($this->getConnection());
		}
	}

	/** 
	 * commit 
	 *
	 * mssql ڵ commit ϱ  ڵcommit    ݵ begin() ޼ҵ带  ؾѴ.
	 * 
	 * @return bool
	 * @see Mssql::begin(), Mssql::rollback();
	 */
	public function commit() { 
		return $this->query("COMMIT TRAN");
	}

	/**
	 * ¡ DBData ü  
	 *
	 * @param resource $result select  resource 
	 * @param int $page   
	 * @param int $pagesize   Ʈ  
	 * @param string $baseClass ʱȭ DBData  Ŭ ̸ 
	 * @return DBData
	 */
	public function createPageData($result, $page, $pagesize) {
		// ⺻ Data Ŭ ϰ 
		// Data Ŭ  ٸ Data Ŭ ϸ ȴ. 
		$data = new DBData();
		$data->setBaseClass($baseClass);
		$data->setDatabase($this);

		//ʵ Ʈ 
		$data->setFields($this->getFieldList($result));
		
		if (!$result) 
			return $data;

		while($d = $this->fetch($result)) 
			$data->add($d);

		return $data;
	}

	/**
	 *  ޼ 
	 * 
	 * @return string  ޼ 
	 */
	public function error() {
		return "";
	}




	/**
	 *  select  ؼ fetch    (row) Ѵ. 
	 *
	 * ϵǴ  array('ʵ' => '', ...); ¸ . 
	 * 
	 * @param resource $result select   resource
	 * @return array row Ÿ 
	 */
	public function fetch($result) {
		return mssql_fetch_assoc($result);
	}

	/** 
	 * ޸  
	 * 
	 * @return bool
	 */
	public function free($result) { 
		return mssql_free_result($result);
	}

	/**
	 *    ʵ  Ѵ.
	 *
	 * @param resource $result select   resource
	 * @return int ʵ尳 
	 */
	public function getFieldCount($result) {
		return mssql_num_fields($result);
	}

	/**
	 *  ġ ʵ ̸ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵ̸ 
	 */
	public function getFieldName($result, $i) {
		return mssql_field_name($result, $i);
	}

	/**
	 *  ġ ʵ Ÿ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵŸ
	 */
	public function getFieldType($result, $i) {
		return mssql_field_type($result, $i);
	}

	/**
	 * select  ؼ ¡ DBData Ѵ. 
	 *
	 * @param string $query select 
	 * @param int $page    
	 * @param int $count  Ʈ  
	 * @param string $baseClass  DBData   Ŭ , ⺻ DBData  
	 * @return DBData
	 */
	public function getPageData($query, $page = 1, $count = 10) {
		$total = $page * $count;

		$query = "select top {$total} * from ($query) TEMP_SELECT ";

		// ..
		$this->query($query, $total);

		// ġ ̵ 
		$this->seek(($page-1)*$count);

		$data = $this->createData($this->getResult());

		return $data;

	}

	/**
	 * ʵ Ÿ(ڷ) php    
	 *
	 * @param string $type ŸԹڿ 
	 * @return int|string PHP
	 */
	public function getTypeConstant($type)
	{
		$type = strtolower($type);

		switch ($type) {
			case 'char':
				return SQLCHAR;
			case 'smalldatetime' :
			case 'datetime' :
			case 'varchar': 
			case 'nvarchar':
			case 'binary':
			case 'image':
			case 'varbinary':
			case 'sql_variant':
				return SQLVARCHAR;
			case 'tinyint': 
			case 'smallint':
			case 'int': 
			case 'bigint':
			case 'timestamp':
				return SQLINT4;
			CASE 'text' : 
			CASE 'ntext':
				return SQLTEXT;
			case 'bit' : 
				return SQLBIT;
			case 'float' :
			case 'decimal' :
			case 'money' : 
			case 'real':
			case 'numeric':
			case 'smallmoney':
			case 'money':
				return SQLFLT8;
			default: 
				return SQLVARCHAR;
		}
	}

	/**
	 * ʵ Ÿ(ڷ) DB Էµ  ִ ڿ  
	 *
	 * @param string $type ŸԹڿ 
	 * @param mixed $value Է°
	 * @param boolean $is_null  üũ   , true üũ, false  üũ  
	 * @return string ȯ ڿ
	 */
	public function getTypeString($type, $value, $is_null = false) { 
		$type = strtoupper($type);
		$temp = '';
		switch ($type) {
			case 'binary':
			case 'char': 
			case 'datetime' :
			case 'image':
			case 'smalldatetime' :
			case 'sql_variant':
			case 'text': 
			case 'varbinary':
			case 'varchar': 
				$temp = sprintf("'%s'", $this->escape($value));
				break;
			case 'nchar':
			case 'ntext':
			case 'nvarchar':
				$temp = sprintf("N'%s'", $this->escape($value));
				break;
			case 'bigint':
			case 'bit' : 
			case 'int': 
			case 'smallint':
			case 'timestamp':
			case 'tinyint': 
				$temp = intval($value);
				break;
			case 'decimal' :
			case 'float' :
			case 'money' : 
			case 'real':
				$temp = floatval($value);
				break;
			default: 
				$temp = $value;
				break;
		}

		return ($is_null && is_null($value)) ? 'NULL' : $temp;
	}



	/**
	 *   2 ̻ select  Ǿ ִٸ  result set ȯѴ. 
	 *
	 * <code>
	 * $resource = $mssql->query("select 1; select 2");
	 * 
	 * $second_result = $mssql->nextResult($result);
	 *
	 * echo $mssql->fetch($second_result);   // array([2] => 2)
	 *
	 * </code>
	 * 
	 * @param resource $result select  resource
	 * @return resource ι° select  resource
	 */
	public function nextResult($result) {
		return mssql_next_result($result);
	}


	/** 
	 * Ϲ   
	 * 
	 * @param string $sql  query 
	 * @param int $batch_size Ǿ ѹ ޸𸮿  ڵ  
	 * @return resource  resource
	 */
	public function query($sql, $batch_size = -1) {

		$this->addSql($sql);

		$args = array($sql, $this->getConnection());

		if ($batch_size > 0) { 
			$args[] = $batch_size;
		} 

		$this->setResult(call_user_func_array('mssql_query', $args));

		return $this->getResult();
	}	

	/**
	 * ũ   Ҷ ̸ ־ ϴ ޼ҵ
	 *
	 * @return bool 
	 */
	public function remote()
	{
		return $this->query("SET ANSI_NULLS ON ; SET ANSI_WARNINGS ON;");
	}

	/**
	 *  row ʵ  ٷ  
	 *
	 * @param resource $result select  resource
	 * @param int $row rowȣ,  0  
	 * @param int|string $field ʵġ( 0) Ǵ ʵ̸, Ǵ table.ʵ̸ 
	 * @return mixed
	 */
	public function result($result, $row, $field) 
	{
		return mssql_result($result, $row, $field);
	}

	/** 
	 * rollback
	 *
	 * @return bool 
	 */
	public function rollback() { 
		return $this->query("ROLLBACK TRAN");
	}

	/**
	 * Ŀ ̵ 
	 * 
	 * @param int $count ̵ų ġ,  0 
	 * @return bool
	 */
	public function seek($count) { 
		return mssql_data_seek($this->getResult(), $count);
	}

	/** 
	 * ν ʱȭ 
	 * 
	 * @param string $sp_name ν̸ 
	 * @return resource ʱȭ resource
	 * @deprecated 
	 */
	public function prepare($sp_name) {
		$this->setStatement(mssql_init($sp_name, $this->getConnection()));

		return $this->getStatement();
	}

	/** 
	 * bind ޼ҵ 
	 *
	 * @param string $name ε ̸ 
	 * @param string $type ε Ÿ, Ÿ̽  Ʋ 
	 * @param string $output output , in, out, inout, return 
	 * @param int $length Ÿ, -1  
	 * @param mixed $value  Ÿ Ǵ output   Ÿ
	 * @return bool 
	 */
	public function bind($name, $type = '', $output = 'in', $length = -1, &$value = null){

		$output = strtolower($output);		

		// Ķ ̸ 
		$param	= '@'.$name;

		if ($output == 'return') { 
			$param = 'RETVAL';
		}

		// output  
		$isOutput = ($output == 'in') ? false : true;

		//   
		$isNull = true;

		return mssql_bind($this->getStatement(), $param, $value, $this->getTypeConstant($type), $isOutput, $isNull, $length);
	}


	/**
	 * ν  
	 *
	 * ν  resource select    Ǿٸ select  resource ȯѴ. 
	 * 
	 * @return resource|bool ν  ҽ
	 * @deprecated 
	 */
	public function execute() {
		return mssql_execute($this->getStatement());
	}

	/**
	 * ν ޸  
	 * 
	 * @param resource $stmt mssql_init() Լ   resource 
	 * @return bool  
	 * @see Mssql::init()
	 */
	public function freeStatement($stmt) {
		// 
		return mssql_free_statement($stmt);
	}
	
	/**
	 * ν  ü ´. 
	 * 
	 * @see lib/php/db/DBClient#createProc($name)
	 * @return MssqlProc 
	 */
	public function createProc($str, $option = 'proc') { 
		$proc = new OracleProc($this);
		$proc->name($str, $option);
		
		return $proc;
	}	
}

?>